package com.bizvane.mktcenterservice.models.vo.tree3.respvo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class MktLearnCourseDetailRespVO {

    @ApiModelProperty(value = "课程-课程ID")
    private Long mktLearnCourseId;

    @ApiModelProperty(value = "课程-课程名称")
    private String courseName;

    @ApiModelProperty(value = "课程-课程类型 1视频 2图文")
    private Integer courseType;

    @ApiModelProperty(value = "课程-课程背景图")
    private String courseBgi;

    @ApiModelProperty(value = "课程-课程总秒数")
    private Integer courseTotalSecond;

    @ApiModelProperty(value = "0免费 1付费")
    private Integer coursePointWay;

    @ApiModelProperty(value = "课程-成本积分")
    private Integer costPoint;

    @ApiModelProperty(value = "课程-奖励积分")
    private Integer rewardPoint;

    @ApiModelProperty(value = "课程-课程描述")
    private String courseDesc;

    @ApiModelProperty(value = "课程-查看次数")
    private Integer viewNum;

    @ApiModelProperty(value = "会员剩余积分")
    private Integer countIntegral;

    @ApiModelProperty(value = "课程-运营标签列表")
    private List<String> operationLabelList;

    @ApiModelProperty(value = "课程-课程内容列表")
    private List<CourseContentRespVO> courseContentList;



    @ApiModelProperty(value = "课程-课程总学习秒数")
    private Integer courseTotalLearnSecond;

    @ApiModelProperty(value = "课程-学习状态 0浏览 1学习中 2已完成")
    private Integer state;

    @ApiModelProperty(value = "课程-兑换状态 0未兑换 1已兑换")
    private Integer exchangeState;

    @Data
    public static class CourseContentRespVO {

        @ApiModelProperty(value = "课程内容-课程内容ID")
        private Long mktLearnCourseContentId;

        @ApiModelProperty(value = "课程内容-视频名称")
        private String videoName;

        @ApiModelProperty(value = "课程内容-视频描述")
        private String videoDesc;

        @ApiModelProperty(value = "课程内容-课程秒数")
        private Integer courseSecond;

        @ApiModelProperty(value = "课程内容-课程内容")
        private String content;

        @ApiModelProperty(value = "课程内容-学习秒数")
        private Integer learnSecond;

        @ApiModelProperty(value = "课程内容-播放秒数")
        private Integer playSecond;

        @ApiModelProperty(value = "课程内容-学习状态 0未完成 1已完成")
        private Integer state;

    }

}
