package com.bizvane.mktcenterservice.models.newmkt;

import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktReceiveCouponActivityVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 活动编号
     */
    private String taskCode;

    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 是否可用领取
     */
    private Boolean show;

    /**
     * 剩余领取数量
     */
    private Integer count;

    /**
     * 是否是优惠券 true是 false 礼包
     */
    private Boolean hasCoupon;

    /**
     * 券列表
     */
    private MktMemActivityCouponVO coupon;

    /**
     * 礼包列表
     */
    private MktMemActivityGiftBagVO mktGiftBagVo;


}
