package com.bizvane.mktcenterservice.models.bo;

import lombok.Data;

import java.util.Date;

/**
 * @author yuantq
 * @date 2023/6/29
 */
@Data
public class MktpActivityAwardRecordBO {

    private Long mktActivityPrizeRecordId;

    /**
     * 奖品类型：10-积分，20-优惠券（现金，折扣）,30-兑换券（礼品券）40-实物奖品 50-微信红包封面
     */
    private Integer awadType;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     *  红包封面地址
     */
    private String awardWxRedPacketCoverUrl;

    /**
     * 联系客服员工活码ID
     */
    private Long staffLiveCodeId;

    /**
     * 中奖时间
     */
    private Date prizeTime;

    private Integer exchangeType;

    private Date exchangeDeadline;

    private Integer physicalExtractionType;

    private String linkmanProvince;

    private String linkmanCity;

    private String linkmanDistrict;

    private String linkmanName;

    private String linkmanPhone;

    private String linkmanAddress;

    private String storeScopeCode;

    private Date pickUpTime;

    private String pickUpStoreId;

    private String pickUpStoreName;

    private String operatorId;

    private String operatorName;

    /**
     * 奖品图片
     */
    private String imageUrl;

    /**
     * 实物兑奖剩余时间(提货期限)
     */
    private Integer entityExchangeDay;

    /**
     * 奖品状态(0.未填写提货方式及信息,1.已填写提货方式及信息,2.已提货,3.已过期)
     */
    private Integer entityPriceStatus;

    /**
     * 提货时间限制是否开启	0.关闭(无限制) 1.开启(有限制)
     */
    private Integer pickUpTimeSwitch;

    /**
     * 提货开始时间
     */
    private Date pickUpBeginTime;

    /**
     * 提货结束时间
     */
    private Date pickUpEndTime;

}
