package com.bizvane.mktcenterservice.interfaces.mktp;

import com.bizvane.mktcenterservice.models.po.MktpActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.mktp.MktpActivityParamsVO;
import com.bizvane.mktcenterservice.models.vo.mktp.MktpActivityVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/6/21
 */
public interface MktpActivityService {

    /**
     * 根据小程序路径获取对应微信链接
     * @param brandId
     * @param activeCode
     * @param wxPath
     * @return
     */
    String getWxUrl(Long brandId, String activeCode, String wxPath);

    /**
     * 新增活动主体
     * @param mktpActivityPO
     * @param sysAccountPO
     * @param wxUrl
     * @return
     */
    Long addMktpActivity(MktpActivityPOWithBLOBs mktpActivityPO, SysAccountPO sysAccountPO, String wxUrl);

    /**
     * 分页获取活动列表
     * @param mktpActivityParamsVO
     * @return
     */
    ResponseData<PageInfo<MktpActivityVO>> selectActivityListPage(MktpActivityParamsVO mktpActivityParamsVO);

    /**
     * 根据活动id获取活动主表信息
     * @param mktpActivityId
     * @return
     */
    MktpActivityVO getMktpActivityVOById(Long mktpActivityId);

    /**
     *
     * @param activityCode
     * @return
     */
    MktpActivityVO getMktpActivityVOByCode(String activityCode);

    /**
     * 修改活动
     * @param updateMktpActivityPO
     * @param sysAccountPO
     */
    void updateMktpActivity(MktpActivityPOWithBLOBs updateMktpActivityPO, SysAccountPO sysAccountPO);

    /**
     * 禁用活动
     * @param stopMktpActivityPO
     */
    void stopMktpActivity(MktpActivityPOWithBLOBs stopMktpActivityPO);

    /**
     * 获取同时间段内客户群活码使用数量
     * @param mktpActivityVO
     * @return
     */
    long countOtherActivity(MktpActivityVO mktpActivityVO);
}
