package com.bizvane.mktcenterservice.models.vo.tree3.respvo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class GetCertificationInfoRespVO {


    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty("会员编号")
    private String memberCode;

    @ApiModelProperty("会员姓名")
    private String memberName;

    @ApiModelProperty("会员头像")
    private String memberPhoto;

    @ApiModelProperty("性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("首次参加工作日期")
    private String firstWorkDate;
    @ApiModelProperty("工龄")
    private Long workAge;


    @ApiModelProperty("施工能力集合")
    private String constructabilityNames;
    private String constructabilityIds;

    @ApiModelProperty("三棵树认证证书列表")
    private List<CertVo> treeTreesCertVoList;

    @ApiModelProperty("国家认证证书列表")
    private List<CertVo> countryCertVoList;


    @Data
    public static class CertVo {
        @ApiModelProperty("活动id")
        private Long mktActivityCertificationId;
        @ApiModelProperty("认证类型id")
        private Long certificationTypeId;
        @ApiModelProperty("认证类型（1三棵树认证 2国家认证)")
        private Integer certificationType;
        @ApiModelProperty("认证名称")
        private String certificationName;
        @ApiModelProperty("认证简称")
        private String certificationSimpleName;
        @ApiModelProperty("认证简介")
        private String certificationDesc;
        @ApiModelProperty("证书状态")
        private Integer certState;
        @ApiModelProperty("证书级别")
        private String certLevel;
        @ApiModelProperty("证书编号")
        private String certNo;
        @ApiModelProperty("证书颁发时间")
        private Date issueTime;
        @ApiModelProperty("证书过期时间")
        private Date expireTime;
        @ApiModelProperty("证书")
        private String certImg;



    }
}
