package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ActivityCheckRulesRequestVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 子商户号
     */
    private String subMerchantId;
    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 数据串
     */
    private String data;

    /**
     * 活动编号
     */
    private String taskCode;

    /**
     * 会员code
     */
    private String memberCode;

    /**
     * 订单金额
     */
    private BigDecimal payMoney;

    /**
     * 消费门店id
     */
    private Long serviceStoreId;

    /**
     * 商品productNos
     */
    private String itemIds;

    /**
     * 策略类型
     */
    private String strategyType;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO mbrGroup;

    /**
     * 店铺信息
     */
    private MktMemActivityGroupVO storeGroup;

    /**
     * 商品信息
     */
    private MktMemActivityGroupVO itemGroup;

    private String mbrGroups;

    private String storeGroups;

    private String itemGroups;
}
