package com.bizvane.mktcenterservice.models.po;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 自动任务配置表
 * @author lipeng
 */
@Data
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MktAutoTaskDefPO implements Serializable {

    private static final long serialVersionUID = -4727301222720825725L;

    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "autoTaskDefId", required = false, example = "")
    private Long autoTaskDefId;

    @io.swagger.annotations.ApiModelProperty(value = "任务编号", name = "taskCode", required = false, example = "")
    private String taskCode;

    @io.swagger.annotations.ApiModelProperty(value = "所属企业id", name = "sysCompanyId", required = false, example = "")
    private Long sysCompanyId;

    @io.swagger.annotations.ApiModelProperty(value = "所属品牌id", name = "sysBrandId", required = false, example = "")
    private Long sysBrandId;

    @io.swagger.annotations.ApiModelProperty(value = "任务名称", name = "taskName", required = false, example = "")
    private String taskName;

    @io.swagger.annotations.ApiModelProperty(value = "任务开始时间", name = "startTime", required = false, example = "")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @io.swagger.annotations.ApiModelProperty(value = "任务结束时间", name = "endTime", required = false, example = "")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @io.swagger.annotations.ApiModelProperty(value = "有效期类型(0-长期有效，1-阶段有效)", name = "timeValidType", required = false, example = "")
    private String timeValidType;

    @io.swagger.annotations.ApiModelProperty(value = "消费时间", name = "consumeTime", required = false, example = "")
    private Integer consumeTime;

    @io.swagger.annotations.ApiModelProperty(value = "任务执行周期：0日，1周，2月", name = "taskCycle", required = false, example = "")
    private Integer taskCycle;

    @io.swagger.annotations.ApiModelProperty(value = "触发时间", name = "triggerTime", required = false, example = "")
    private Integer triggerTime;

    @io.swagger.annotations.ApiModelProperty(value = "活动状态：1待执行，2执行中，3已结束，4已禁用", name = "taskStatus", required = false, example = "")
    private Integer taskStatus;

    @io.swagger.annotations.ApiModelProperty(value = "数据有效性 1=有效 0=无效", name = "valid", required = false, example = "")
    private Integer valid;

    @io.swagger.annotations.ApiModelProperty(value = "备注", name = "remark", required = false, example = "")
    private String remark;

    private Integer createUserId;

    private String createUserName;

    private Date createDate;

    private Long modifiedUserId;

    private String modifiedUserName;

    private Date modifiedDate;

    private Integer version;

}