package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.ActivityAnalysisCountBO;
import com.bizvane.mktcenterservice.models.bo.CtivityAnalysisBO;
import com.bizvane.mktcenterservice.models.bo.MktYesterdayDataBo;
import com.bizvane.mktcenterservice.models.vo.*;
import com.github.pagehelper.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author Lijc
 * @date on 2019年10月17日15:20:09
 */
public interface MktBigScreenService {

    /**
     * 查询启用中的营销个数
     * @param sysAccountPO
     * @return
     */
    ResponseData<MktBeginningVO> getBeginMarket(SysAccountPO sysAccountPO);


    /**
     * 获取昨日营销数据
     * @param bo
     * @return
     */
    ResponseData<MktYesterdayDataVO> getYesterdayMktData(MktYesterdayDataBo bo);

    /**
     * 查询待启用中的营销列表
     * @param sysAccountPO
     * @param pageForm
     * @return
     */
    ResponseData<PageInfo<MktToBeExecutedVO>> getToBeExecutedMarket(SysAccountPO sysAccountPO, PageForm pageForm);

    /**
     * 查询营销列表
     * @param vo
     * @return
     */
    ResponseData<PageInfo<ActivityAnalysisCountVO>> getMarketList(MktListRequestVO vo);



}
