package com.bizvane.mktcenterservice.interfaces;


import java.util.ArrayList;
import java.util.List;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;


public interface ActivityManualService {

  ResponseData<ActivityVO> getActivityManualList(ActivityVO vo , PageForm pageForm,SysAccountPO stageUser);

  ResponseData<Integer> addActivityManual(ActivityBO bo,SysAccountPO stageUser);
  
  int addActivityQRcode(List<Long> idList, SysAccountPO stageUser);

  ResponseData<Integer> updateActivityManual(ActivityBO bo, SysAccountPO stageUser);

  @Deprecated
  ResponseData<ActivityManualVO> executeActivity(ActivityManualVO vo);

  ResponseData<ActivityManualVO> executeActivityNew(ActivityManualVO vo);

  ResponseData<List<ActivityBO>> getActivityManualEffect(ActivityVO vo);

  ResponseData<ActivityBO> selectActivityManualByBusinessCode(String businessCode);

  ResponseData<List<ActivityVO>>  getActivityByMemberInfo(MemberInfoModel memberInfoModel,Integer activityType, String openId);

  ResponseData<ArrayList<ActivityVO>>  getActivityByQrcode(MemberInfoModel memberInfoModel, String activityCode, Integer activityType,String openId);

  ResponseData<Integer>  checkActivity(SysCheckPo po, SysAccountPO sysAccountPO);

  ResponseData validateActivity(ActivityManualVO vo);

  ResponseData<String> createposterQrcode(ActivityVO vo, SysAccountPO sysAccountPO);

    ResponseData<String> getPosterQrcode(ActivityVO vo, SysAccountPO stageUser);
}
