package com.bizvane.mktcenterservice.common;

/**
 * @author yuantq
 * @date 2022/7/18
 */
public enum ReceiveStatusEnum {
    //    1-今日已领完(每人每日单张券)，2-今日已领取(每人每日所有券)，3-已领完(每人最多单张券)，4-已领取(每人最多所有券)，5-已领完(活动单张券)，6-已领完(活动所有券)
    PERSON_DAY_SINGLE_STATUS(1,"今日已领完"),

    PERSON_DAY_ALL_STATUS(2,"开启"),

    PERSON_SINGLE_STATUS(3,"已领完"),

    PERSON_ALL_STATUS(4,"已领取"),

    ACTIVITY_SINGLE_STATUS(5,"已领完"),

    ACTIVITY_ALL_STATUS(6,"已领完");

    /**
     * 领完状态
     */
    private Integer type;
    /**
     * 备注
     */
    private String remark;

    ReceiveStatusEnum(Integer type, String remark) {
        this.type = type;
        this.remark = remark;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }}
