package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.MktGeneralizeBo;
import com.bizvane.mktcenterservice.models.vo.MktGeneralizeSearchVo;
import com.bizvane.mktcenterservice.models.vo.MktGeneralizeVo;
import com.bizvane.mktcenterservice.models.vo.RetryMktGeneralizeChannelQrVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

/**
 * @author zcc
 * @date 2021/11/23 13:45
 * 内容推广Service
 **/
public interface MktGeneralizeService {
    /**
     * 新增
     * @param mktGeneralizeBo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> add(MktGeneralizeBo mktGeneralizeBo, SysAccountPO sysAccountPO);

    /**
     * 分页
     * @param mktGeneralizeSearchVo
     * @param sysAccountPO
     * @return
     */
    ResponseData<PageInfo<MktGeneralizeVo>> page(MktGeneralizeSearchVo mktGeneralizeSearchVo, SysAccountPO sysAccountPO);

    /**
     * 编辑
     * @param mktGeneralizeBo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> update(MktGeneralizeBo mktGeneralizeBo, SysAccountPO sysAccountPO);

    /**
     * 推广内容操作
     * @param operateType
     * @param mktGeneralizeId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> operate(Integer operateType, Long mktGeneralizeId, SysAccountPO sysAccountPO);

    /**
     * 详情
     * @param mktGeneralizeId
     * @param sysAccountPO
     * @return
     */
    ResponseData<MktGeneralizeBo> getById(Long mktGeneralizeId, SysAccountPO sysAccountPO);

    /**
     * 二维码批量任务重试
     * @param retryMktGeneralizeChannelQrVo
     * @return
     */
    ResponseData<String> retryGeneralizeChannelQr(RetryMktGeneralizeChannelQrVo retryMktGeneralizeChannelQrVo);

    /**
     * 获取推广信息详情
     * @param sysCompanyId
     * @param sysBrandId
     * @param mktGeneralizeId
     * @return
     */
    ResponseData<MktGeneralizeVo> getGeneralizeVoById(Long sysCompanyId, Long sysBrandId, Long mktGeneralizeId);
}
