package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.mktcenterservice.models.bo.ActivityRedPacketV2BO;
import com.bizvane.mktcenterservice.models.po.MktActivityGameCouponLinkPO;
import com.bizvane.mktcenterservice.models.po.MktActivityGamePicturePO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketPOWithBLOBs;
import lombok.Data;

import java.util.List;

@Data
public class ActivityRedPacketV2VO {

    //主表
    private MktActivityPOWithBLOBs activityPO;
    //奖励
    private MktActivityRedPacketPOWithBLOBs activityRedPacketPO;

    private MktActivityGameCouponLinkPO activityGameCouponLinkPO;

    private MktActivityGamePicturePO activityGamePicturePO;

    private ActivityRedPacketQrCodeVO activityRedPacketQrCodeVO;

    private List<ActivityRedPacketLevelVO> activityRedPacketLevelVOList;

    private List<ActivityRedPacketInitiateLevelVO> activityRedPacketInitiateLevelVOList;

    private List<ActivityRedPacketInvitedLevelVO> activityRedPacketInvitedLevelVOList;

    private CouponDefinitionPO couponDefinitionPO;

    private CouponDefinitionPO rewardCouponDefinition;

    private CouponDefinitionPO rewardCouponDefinitionNewMember;

    private CouponDefinitionPO rewardCouponDefinitionOldMember;

    public ActivityRedPacketV2VO() {
    }

    public ActivityRedPacketV2VO(ActivityRedPacketV2BO activityRedPacketV2BO) {
        if(activityRedPacketV2BO == null) {
            return;
        }

        this.activityPO = activityRedPacketV2BO.getActivityPO();
        this.activityRedPacketPO = activityRedPacketV2BO.getActivityRedPacketPO();
        this.activityGamePicturePO = activityRedPacketV2BO.getActivityGamePicturePO();
        this.activityGameCouponLinkPO = activityRedPacketV2BO.getActivityGameCouponLinkPO();
        this.activityRedPacketLevelVOList = activityRedPacketV2BO.getActivityRedPacketLevelVOList();
        this.activityRedPacketInitiateLevelVOList = activityRedPacketV2BO.getActivityRedPacketInitiateLevelVOList();
        this.activityRedPacketInvitedLevelVOList = activityRedPacketV2BO.getActivityRedPacketInvitedLevelVOList();
        this.couponDefinitionPO = activityRedPacketV2BO.getCouponDefinitionPO();
        this.rewardCouponDefinitionNewMember = activityRedPacketV2BO.getRewardCouponDefinitionNewMember();
        this.rewardCouponDefinitionOldMember = activityRedPacketV2BO.getRewardCouponDefinitionOldMember();
        this.activityRedPacketQrCodeVO = activityRedPacketV2BO.getActivityRedPacketQrCodeVO();
        this.rewardCouponDefinition = activityRedPacketV2BO.getRewardCouponDefinition();
    }

    public static ActivityRedPacketV2VO onlyShowQrCode(ActivityRedPacketV2BO activityRedPacketV2BO){
        ActivityRedPacketV2VO activityRedPacketV2VO = new ActivityRedPacketV2VO();
        activityRedPacketV2VO.setActivityRedPacketQrCodeVO(activityRedPacketV2BO.getActivityRedPacketQrCodeVO());
        return activityRedPacketV2VO;
    }
}
