package com.bizvane.mktcenterservice.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.mktcenterservice.models.bo.ActivityRedPacketBO;
import com.bizvane.mktcenterservice.models.bo.ActivityRedPacketListBO;
import com.bizvane.mktcenterservice.models.bo.ActivityRedPacketV2BO;
import com.bizvane.mktcenterservice.models.bo.MktActivityRedPacketRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketBatchPO;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketRecordPO;
import com.bizvane.mktcenterservice.models.vg.*;
import com.bizvane.mktcenterservice.models.vo.ActivityPriceParamVO;
import com.bizvane.mktcenterservice.models.vo.ActivityRedPacketV2VO;
import com.bizvane.mktcenterservice.models.vo.ActivityRedPacketVO;
import com.bizvane.mktcenterservice.models.vo.RedPacketSocketVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2019/1/11 13:54
 */
public interface ActivityRedPacketService {
    public ResponseData<JSONObject> addActivityRedPacket(ActivityRedPacketBO bo, HttpServletRequest request) throws ParseException;
    public ResponseData<JSONObject> updateActivityRedPacket(ActivityRedPacketBO bo, HttpServletRequest request) throws ParseException;
    public ResponseData<ActivityRedPacketBO> selectActivityRedPacket(ActivityRedPacketVO vo);
    public ResponseData<PageInfo<MktActivityPOWithBLOBs>>  selectActivityRedPacketList(ActivityPriceParamVO vo, HttpServletRequest request);
    public ResponseData<ActivityRedPacketBO> selectActivityRedPacketDetail(ActivityRedPacketVO vo);
    public ResponseData<Integer> doIfActivityRedPacket(ActivityRedPacketVO vo);
    public ResponseData<PageInfo<ActivityRedPacketListBO>> selectActivityRedPacketAnalyzeLists(ActivityRedPacketVO vo, HttpServletRequest request);
    public ResponseData<PageInfo<MktActivityRedPacketRecordBO>> getRedPacketCoponRecord(ActivityRedPacketVO vo, HttpServletRequest request);
    public ResponseData<List<MktActivityRedPacketRecordPO>> getRedPacketZhuLiRecord(ActivityRedPacketVO vo);
    public void andActivityRedPacketCreateRecord(ActivityRedPacketVO vo);
    public ResponseData<Integer> andActivityRedPacketZhuliRecord(ActivityRedPacketVO vo) throws IOException;
    public ResponseData<Integer> andActivityRedPacketSendCouponRecord(ActivityRedPacketVO vo);
    public ResponseData<List<MktActivityRedPacketRecordBO>> getRedPacketCoponAppRecord(ActivityRedPacketVO vo);
    public ResponseData<Integer> stopActivityRedPacket(MktActivityPOWithBLOBs po, HttpServletRequest request);
    public ResponseData<RedPacketSocketVO> getRedPacketZhuLiRecordByAPP(ActivityRedPacketVO vo);

    ResponseData<String> checkRedPacketParam(Long sysCompanyId, Long mktActivityId, Date startTime, Date endTime);
    public ResponseData<ActivityRedPacketV2VO> addActivityRedPacketV2(ActivityRedPacketV2BO bo, HttpServletRequest request) throws ParseException;
    public ResponseData<ActivityRedPacketV2VO> selectActivityRedPacketV2(ActivityRedPacketVO vo);
    public VGActivityJudgeMemberConditionResponseVo judgeMemberCondition(@RequestBody VGActivityJudgeMemberConditionRequestVo vo);
    public MktActivityRedPacketBatchPO selectActivityRedPacketMemberDoingBatchDetail(VGActivityMemberRequestVo vo);
    public ResponseData<MktActivityRedPacketBatchPO> andActivityRedPacketCreateRecordV2(ActivityRedPacketVO vo);
    public ResponseData<ActivityRedPacketInvitedRewardVo> andActivityRedPacketZhuliRecordV2(VGActivityRedPacketInvitedRequestVo vo);
    public ResponseData<RedPacketSocketVO> getRedPacketZhuLiRecordByAPPV2(VGActivityRedPacketInvitedRequestVo vo);
    public ResponseData<VGActivityRedPacketDetailVO> selectActivityRedPacketMemberDetail(VGActivityRedPacketInvitedRequestVo vo);
    public ResponseData<Boolean> beforeCheckActivityRedPacketSendCouponRecordCount(VGActivityRedPacketInvitedRequestVo vo);
    public ResponseData<VGActivityRedPacketDetailVO> andActivityRedPacketSendCouponRecordV2(VGActivityRedPacketInvitedRequestVo vo);
    public VGActivityRedPacketPriceRecordResponseVO getActivityRedPacketPriceRecord(@RequestBody ActivityRedPacketVO vo);
    public ResponseData<MktActivityRedPacketBatchPO> selectActivityRedPacketBatch(VGActivityRedPacketInvitedRequestVo vo);

}
