package com.bizvane.mktcenterservice.rpc;

import com.bizvane.appletservice.models.bo.IntegralActivityGoodBO;
import com.bizvane.centercontrolservice.models.bo.AppletFunctionBO;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by Geng on 2018/8/9.
 */

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskForWXRpc")
public interface TaskServiceForWXRpc {



    @RequestMapping("/getCompleteTask")
    @io.swagger.annotations.ApiModelProperty(value = "brandId,memberCode",name = "该会员已完成和未完成的任务列表", required = false,example = "")
    public ResponseData<PageInfo<TaskWXBO>> getCompleteTask(@RequestBody TaskForWXVO vo);

    @RequestMapping("/getTaskWXDetail")
    @io.swagger.annotations.ApiModelProperty(value = "taskId",name = "任务code", required = false,example = "")
    public  ResponseData<TaskWXDetailBO>  getTaskWXDetail(@RequestParam Long taskId);

    @RequestMapping("/getMemberTaskWXDetail")
    @io.swagger.annotations.ApiModelProperty(value = "taskId,memberCode",name = "查询会员指定任务详情", required = false,example = "")
    ResponseData<TaskWXDetailBO>  getMemberTaskWXDetail(@RequestParam("taskId") Long taskId,@RequestParam("memberCode") String memberCode,@RequestParam("sysBrandId") Long sysBrandId);

    @RequestMapping("/getURLDetail")
    @io.swagger.annotations.ApiModelProperty(value = "TaskForWXVO",name = "获取url链接详情", required = false,example = "")
    public  ResponseData<AppletFunctionBO>  getURLDetail(@RequestBody TaskForWXVO vo);

    //积分兑换券
    //查询对换列表
    @RequestMapping("/getConvernCouponLists")
    public ResponseData<CouponIntegralExchangeBO> getConvernCouponLists(@RequestBody CouponRecordVO vo);
   //券详情和单价
    @RequestMapping("/getCouponAndPrice")
    public ResponseData<CouponIntegralExchangeVO> getCouponAndPrice(@RequestBody CouponRecordVO vo);
    //兑换
    @RequestMapping("/doConvernCoupon")
    public ResponseData<String> doConvernCoupon(@RequestBody CouponRecordVO vo);
    //查询已兑换
    @RequestMapping("/getConvernConpouByMember")
    public ResponseData<PageInfo<MktConvertCouponRecordPO>> getConvernConpouByMember(@RequestBody CouponRecordVO vo);

    //兑换券记录详情
    @RequestMapping("/getConvernConpouDetail")
    public ResponseData<MktConvertCouponRecordPO> getConvernConpouDetail(@RequestParam("convertCouponRecordId") Long convertCouponRecordId);

    /**
     * 获取兑换券基础信息
     * @param sysBrandId
     * @param exchangeCode
     * @return
     */
    @RequestMapping("/getMktCouponIntegralExchangeBaseVOByExchangeCode")
    public ResponseData<MktCouponIntegralExchangeBaseVO> getMktCouponIntegralExchangeBaseVOByExchangeCode(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("exchangeCode") String exchangeCode);

    //兑换校验
    @RequestMapping("/validateConvernCoupon")
    public ResponseData validateConvernCoupon(@RequestBody CouponRecordVO vo);

    //支付成功
    @RequestMapping("paySuccess")
    public ResponseData<MktConvertCouponRecordPO> paySuccess(@RequestParam("convertCouponRecordId") Long convertCouponRecordId);

    @RequestMapping("getGiftBag")
    public ResponseData<MktGiftBagVO> getGiftBag(@RequestParam("bizId") Long bizId);
    //查询所有上架优惠券接口
    @GetMapping("getShelfIntegralCoupon")
    public ResponseData<List<IntegralActivityGoodBO>> getShelfIntegralCoupon(@RequestParam Long brandId);
    /**
     * @author Ngp
     * @date 2021/11/23
     * @description 上下架积分兑换券(自动上架接口)
     **/
    @GetMapping("autoShelfIntegralCoupon")
    public ResponseData<String> autoShelfIntegralCoupon(@RequestParam Long exchangeId,@RequestParam Boolean shelfJudge);

    /**
     * 查询邀请开卡任务记录
     * @param taskVO
     * @return
     */
    @PostMapping("/selectInvitationRecord")
    ResponseData<PageInfo<CompanyMemberInfoBo>> selectInvitationRecord(@RequestBody TaskForWXVO taskVO);

    @RequestMapping("judgeMember")
    ResponseData judgeMember(@RequestBody JudgeMemberVO vo);
}
