package com.bizvane.mktcenterservice.models.dto;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuantq
 * @date 2023/3/3
 */
@Data
public class MktPopupAdvertisementUpdateDTO implements Serializable {

    private static final long serialVersionUID = 8142931564462378098L;

    private Long mktPopupAdvertisementId;

    private Long sysCompanyId;

    private Long sysBrandId;

    /**
     * 投放人群类型0:全部会员   2:指定会员
     */
    private Integer mbrConditionType;

    /**
     * 人群条件
     */
    private String mbrCondition;

    /**
     * 投放页面类型
     */
    private Integer popupWebType;

    /**
     * 投放结束时间
     */
    private Date endTime;

    /**
     * 投放频率 0=永久一次，1-每次进入
     */
    private Integer frequencyType;

    /**
     * 广告名称
     */
    private String advertisementName;

    /**
     * 广告图片路径
     */
    private String advertisementImgUrl;

    /**
     * 高度
     */
    private Integer popupImgHeight;

    /**
     * 宽度
     */
    private Integer popupImgWeight;

    /**
     * 跳转路径
     */
    private String linkUrl;

    private JSONObject linkUrlJson;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 曝光次数
     */
    private Long scanNum;

    /**
     * 点击次数
     */
    private Long clickNum;

    /**
     * 上下架状态：1-已上架，2-已下架
     */
    private Integer status;

    /**
     * 投放状态 1-待投放，2-投放中，3-已结束，4-已关闭
     */
    private Integer popupStatus;


}
