package com.bizvane.mktcenterservice.models.dto;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuantq
 * @date 2023/3/3
 */
@Data
public class MktPopupAdvertisementAddDTO implements Serializable {

    private static final long serialVersionUID = 8819324699650431514L;

    private Long sysCompanyId;

    private Long sysBrandId;

    /**
     * 投放人群类型0:全部会员   2:指定会员
     */
    private Integer mbrConditionType;

    /**
     * 人群条件
     */
    private String mbrCondition;

    /**
     * 投放页面类型
     */
    private Integer popupWebType;

    /**
     * 投放开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date startTime;

    /**
     * 投放结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date endTime;

    /**
     * 投放频率：0=永久一次；1=每次进入
     */
    private Integer frequencyType;

    /**
     * 广告名称
     */
    private String advertisementName;

    /**
     * 广告图片路径
     */
    private String advertisementImgUrl;

    /**
     * 高度
     */
    private Integer popupImgHeight;

    /**
     * 宽度
     */
    private Integer popupImgWeight;

    private String linkUrl;

    private JSONObject linkUrlJson;



}
