package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.dto.MktPopupAdvertisementAddDTO;
import com.bizvane.mktcenterservice.models.dto.MktPopupAdvertisementQueryDTO;
import com.bizvane.mktcenterservice.models.dto.MktPopupAdvertisementUpdateDTO;
import com.bizvane.mktcenterservice.models.po.MktPopupAdvertisementPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.MktPopupAdvertisementDetailVO;
import com.bizvane.mktcenterservice.models.vo.MktPopupAdvertisementVO;
import com.bizvane.mktcenterservice.models.vo.MktPopupResponseInfoVO;
import com.bizvane.mktcenterservice.models.vo.MktPopupResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/3/3
 */
public interface MktPopupAdvertisementService {

    /**
     * 获取弹窗广告列表
     * @param mktPopupAdvertisementQueryDTO
     * @return
     */
    ResponseData<PageInfo<MktPopupAdvertisementVO>> getPopupAdvertisementList(MktPopupAdvertisementQueryDTO mktPopupAdvertisementQueryDTO);

    /**
     * 新增弹窗广告
     * @param mktPopupAdvertisementAddDTO
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> addPopupAdvertisement(MktPopupAdvertisementAddDTO mktPopupAdvertisementAddDTO, SysAccountPO sysAccountPO);

    /**
     * 根据品牌和弹窗广告ID获取详情
     * @param popupAdvertisementId
     * @param sysBrandId
     * @return
     */
    ResponseData<MktPopupAdvertisementDetailVO> getPopupAdvertisementDetailById(Long popupAdvertisementId, Long sysBrandId);

    /**
     * 修改弹窗广告
     * @param mktPopupAdvertisementUpdateDTO
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> updatePopupAdvertisement(MktPopupAdvertisementUpdateDTO mktPopupAdvertisementUpdateDTO, SysAccountPO sysAccountPO);

    /**
     * 根据主键ID修改弹窗广告排序
     * @param mktPopupAdvertisementUpdateDTO
     * @param sysAccountPO
     * @return
     */
    ResponseData<Integer> updatePopupSortById(MktPopupAdvertisementUpdateDTO mktPopupAdvertisementUpdateDTO,SysAccountPO sysAccountPO);

    /**
     * 根据主键ID修改弹窗广告上下架状态
     * @param mktPopupAdvertisementUpdateDTO
     * @param sysAccountPO
     * @return
     */
    ResponseData<Integer> updatePopupStatusById(MktPopupAdvertisementUpdateDTO mktPopupAdvertisementUpdateDTO,SysAccountPO sysAccountPO);

    /**
     * 根据主键ID关闭弹窗广告
     * @param popupAdvertisementId
     * @param sysAccountPO
     * @return
     */
    ResponseData<Integer> closePopupById(Long popupAdvertisementId,SysAccountPO sysAccountPO);

    /**
     * 获取会员小程序弹窗广告列表(最多5个)
     * @param sysBrandId
     * @param memberCode
     * @return
     */
    ResponseData<List<MktPopupResponseVO>> selectPopupAdvertisement(Long sysBrandId, String memberCode);

}
