package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.mktcenterservice.models.po.MktMsgTaskPOWithBLOBs;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Getter
@Setter
public class MktMsgTaskVO extends MktMsgTaskPOWithBLOBs {

    private Long mktMsgTaskId;

    private Long sysCompanyId;

    private Long sysBrandId;

    @NotNull(message = "任务名称不能为空")
    private String taskName;

    private String taskCode;

    private Byte taskStatus;
    @NotNull(message = "任务类型不能为空")
    private Byte taskType;

    private Byte msgPriority;

    private String smsTemplateId;

    private String wechatTemplateId;

    private String contentUrl;
    @NotNull(message = "发送类型不能为空")
    private Byte sendType;
    private Date sendTime;

    @NotNull(message = "发送人群不能为空")
    private Byte msgSource;

    private String msgSkipAppid;

    private Byte msgSkipType;

    private String msgSkipLink;

    private Integer smsMsgCount;

    private Integer smsSendSuccessCount;

    private Integer smsSendFaileCount;

    private Integer wechatMsgCount;

    private Integer wechatSendSuccessCount;

    private Integer wechatSendFaileCount;

    private Long createUserId;

    private String createUserName;

    private Date createDate;

    private Long modifiedUserId;

    private String modifiedUserName;

    private Date modifiedDate;

    private Boolean valid;

    private String smsTemplateJson;

    private String wechatTemplateJson;
    //运营组织code
    private String organizationCode;
    //运营组织名称
    private String organizationName;

    private String templateName;
    //短信模板名称
    private String smsTemplateName;
    //微信模板名称
    private String wechatTemplateName;
    //开始发送时间
    private Date startSendTime;
    //结束发送时间
    private Date endSendTime;
    //开始创建时间
    private Date startCreateDate;
    //结束创建时间
    private Date endCreateDate;

    //分组信息
    private MbrGroupModel mbrGroupModel;
}
