package com.bizvane.mktcenterservice.models.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2020/3/31 11:39
 */
@Data
@ToString
public class OrderDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean hasAll;

    private String orderNo;

    private Long companyId;

    private Long brandId;

    private String memberCode;

    private String erpId;

    // 订单时间
    private String placeOrderTime;

    // 订单付款时间
    private String payTime;

    // 订单发生门店
    private Long serviceStoreId;

    // 订单来源1:线下零售单,2：云仓订单，3：微商城
    private Integer orderFrom;

    // 订单金额
    private BigDecimal payMoney;

    // 成交金额
    private BigDecimal tradeAmount;

    // 订单中商品code集合
    private List<String> productNos;

    //对应订单详情表的 product_no
    private List<String> productNoList;

    //是否为接口来源
    private Boolean isInterfaceSource;


    //原始订单号
    private String  originalOrderNo;

    //获取的积分(线下计算订单所得积分),周凤斌2021年11月16日所提云南361需求
    private Integer getedIntegral;
}
