package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.IntegralActivityCouponAnalyseRequestVo;
import com.bizvane.mktcenterservice.models.vo.MktCouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * Created by wangkeqiang on 2018/11/22.
 */
public interface CouponIntegralExchangeService {

    /**
     * 积分兑换券列表
     * @param vo
     * @param pageForm
     * @param stageUser
     * @return
     */
    public ResponseData<MktCouponIntegralExchangeVO> getCouponIntegralExchangeList(MktCouponIntegralExchangeVO vo, PageForm pageForm, SysAccountPO stageUser);

    /**
     * 查询积分兑换券列表(查询库存大于0的->与小程序列表匹配)
     * @param vo
     * @param pageForm
     * @param stageUser
     * @return
     */
    ResponseData<CouponIntegralExchangeBO> getCouponIntegralExchangeListNew(MktCouponIntegralExchangeVO vo, PageForm pageForm, SysAccountPO stageUser);
    /**
     * 新增积分兑换列表
     * @param vo
     * @return
     */
    public ResponseData<Integer> addCouponIntegralExchange(MktCouponIntegralExchangeVO vo, SysAccountPO stageUser);

    /**
     * 修改积分兑换规则
     * @param vo
     * @param stageUser
     * @return
     */
    public ResponseData<Integer> updateCouponIntegralExchange(MktCouponIntegralExchangeVO vo,SysAccountPO stageUser);

    /**
     * 查看积分兑换规则的详情
     * @param exchangeId
     * @return
     */
    public ResponseData<MktCouponIntegralExchangeVO> selectCouponIntegralExchange(Long exchangeId);

    /**
     *批量上架下架
     * @return
     */
    public ResponseData<Integer> batchUpdateCouponIntegralExchange(MktCouponIntegralExchangeVO vo,SysAccountPO stageUser);
    /**
    * 查询兑换记录详情
    * */
    ResponseData<CouponRecordVO> selectCouponExchangeIntegralRecord(Long recordId);
    /**
    *  积分兑换规则
    *
    * */
    ResponseData deleteCouponExchangeIntegral(Long exchangeId);
    /**
     *  积分活动券分析接口
     * */
    ResponseData getActivityCouponAnalyse(IntegralActivityCouponAnalyseRequestVo requestVO);
    /**
     *  积分活动券分析导出接口
     * */
    ResponseData activityCouponAnalyseExport(IntegralActivityCouponAnalyseRequestVo requestVO, SysAccountPO stageUser);

    ResponseData getShelfIntegralCoupon(Long brandId);

    /**
     *  上下架积分兑换券
     * */
    ResponseData<String> autoShelfIntegralCoupon(Long exchangeId, Boolean shelfJudge);
}
