package com.bizvane.mktcenterservice.common;


public enum CouponSendChannelEnum {
    /**
     * 发券通道一
     */
    CHANNEL_1(1, "发券通道一", 1),
    /**
     * 发券通道二
     */
    CHANNEL_2(2, "发券通道二", 101),
    /**
     * 发券通道三
     */
    CHANNEL_3(3, "发券通道三", 10001),
    /**
     * 发券通道四
     */
    CHANNEL_4(4, "发券通道四", 100001);

    /**
     * 通道类型
     */
    private Integer sendChannelType;
    /**
     * 通道类型名称
     */
    private String channelTypeName;
    /**
     * 通道起始常量
     */
    private Integer sendLimitStart;

    CouponSendChannelEnum(Integer sendChannelType, String channelTypeName, Integer sendLimitStart) {
        this.sendChannelType = sendChannelType;
        this.channelTypeName = channelTypeName;
        this.sendLimitStart = sendLimitStart;
    }

    public static CouponSendChannelEnum getCouponSendChannelEnum(Integer sendChannelType) {
        for (CouponSendChannelEnum couponSendChannelEnum : CouponSendChannelEnum.values()) {
            if (couponSendChannelEnum.getSendChannelType().equals(sendChannelType)) {
                return couponSendChannelEnum;
            }
        }
        //默认返回发券通道四
        return CouponSendChannelEnum.CHANNEL_4;
    }

    public Integer getSendChannelType() {
        return sendChannelType;
    }

    public void setSendChannelType(Integer sendChannelType) {
        this.sendChannelType = sendChannelType;
    }

    public String getChannelTypeName() {
        return channelTypeName;
    }

    public void setChannelTypeName(String channelTypeName) {
        this.channelTypeName = channelTypeName;
    }

    public Integer getSendLimitStart() {
        return sendLimitStart;
    }

    public void setSendLimitStart(Integer sendLimitStart) {
        this.sendLimitStart = sendLimitStart;
    }
}
