package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import lombok.Data;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/5/29
 */
@Data
public class ActivityPrizeRecordDetailBO {
    /**
     * 中奖记录主键ID
     */
    private Long mktActivityPrizeRecordId;

    /**
     * 奖品名称
     */
    private String activityPrizeName;

    /**
     * 奖项类型 ，10-特等奖，20-一等奖，30-二等奖，40-三等奖，50-安慰奖 60-四等奖 依次
     */
    private Integer prizeType;

    /**
     * 奖品类型：10-积分，20-优惠券（现金，折扣）,30-兑换券（礼品券）40-实物奖品 50-微信红包封面
     */
    private Integer awadType;

    /**
     * 奖品状态 0.未兑换-且未填写兑换门店信息 1.已选择兑换门店(正常) 2.已兑换 3.已到期
     */
    private Integer prizeStatus;

    /**
     * 奖品图片
     */
    private String imageUrl;

    /**
     * 中奖时间
     */
    private Date prizeTime;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 提货时间限制是否开启	0.关闭(无限制) 1.开启(有限制)
     */
    private Integer pickUpTimeSwitch;

    /**
     * 提货开始时间
     */
    private Date pickUpBeginTime;

    /**
     * 提货结束时间
     */
    private Date pickUpEndTime;

    /**
     * 预约提货门店ID
     */
    private String storeScopeCode;

    /**
     * 提货门店信息
     */
    private SysStorePo sysStorePo;

}
