package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.vo.MktGeneralizeChannelSearchVo;
import com.bizvane.mktcenterservice.models.vo.MktGeneralizeChannelVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author zcc
 * @date 2021/11/23 16:22
 * 推广内容渠道Service
 **/
public interface MktGeneralizeChannelService {
    /**
     * 分页
     * @param mktGeneralizeChannelSearchVo
     * @param sysAccountPO
     * @return
     */
    ResponseData<PageInfo<MktGeneralizeChannelVo>> page(MktGeneralizeChannelSearchVo mktGeneralizeChannelSearchVo, SysAccountPO sysAccountPO);

    /**
     * 少量批量操作渠道信息
     * @param operateType
     * @param generalizeChannelIdList
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> operateList(Integer operateType, List<Long> generalizeChannelIdList, SysAccountPO sysAccountPO);

    /**
     * 添加渠道信息
     * @param vo
     * @return
     */
    ResponseData<String> addChannel(MktGeneralizeChannelVo vo, SysAccountPO sysAccountPO);

    /**
     * 获取渠道信息selectkey
     * @param mktGeneralizeId
     * @return
     */
    ResponseData<String> getSelectkey(Long mktGeneralizeId, SysAccountPO sysAccountPO);
}
