package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.ActivityAnalysisCountBO;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.bo.CtivityAnalysisBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPointsDistributeAnalysisVO;
import com.bizvane.mktcenterservice.models.vo.ActivityPointsDistributeVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface ActivityPointsDistributeService {
    /**
     * 添加积分派发活动
     * @param bo
     * @param currentUser
     * @return
     */
    ResponseData addActivityPointsDistribute(ActivityBO bo, SysAccountPO currentUser);

    /**
     * 获取积分派发列表(分页)
     * @param vo
     * @param pageForm
     * @param currentUser
     * @return
     */
    ResponseData<PageInfo<ActivityVO>> getListPage(ActivityVO vo, PageForm pageForm, SysAccountPO currentUser);

    /**
     * 获取积分派发活动详情
     * @param vo
     * @return
     */
    ResponseData getActivityById(ActivityVO vo);

    /**
     * 小程序获取积分派发活动详情
     * @param vo
     * @return
     */
    ResponseData<ActivityPointsDistributeVO> getActivityPointsDistribute(ActivityPointsDistributeVO vo);

    /**
     * 小程序执行获取积分派发
     * @param vo
     * @return
     */
    ResponseData<ActivityPointsDistributeVO> executePointsDistributeActivity(ActivityPointsDistributeVO vo);

    /**
     * 积分派发活动效果分析
     * @param bo
     * @param pageForm
     * @return
     */
    ResponseData<CtivityAnalysisBO> getActivityAnalysisPage(ActivityAnalysisCountBO bo, PageForm pageForm);

    /**
     * 获取积分派发活动明细数据
     * @param vo
     * @param pageForm
     * @return
     */
    ResponseData<ActivityPointsDistributeAnalysisVO> getDistributeDetilPage(ActivityPointsDistributeVO vo, PageForm pageForm);

    /**
     * 导出积分派发活动明细数据
     * @param vo
     * @return
     */
    ResponseData<String> exportDistributeDetil(ActivityPointsDistributeVO vo,SysAccountPO stageUser);
}
