package com.bizvane.mktcenterservice.interfaces;


import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.mktcenterservice.models.vo.alipayvoucher.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface ActivityAlipayVoucherApplyService {

    /**
     * 查询支付宝支付页渠道
     */
    ResponseData<PageInfo<AlipayVoucherDeliveryChannelVo>> deliveryChannelQuery(Long mktActivityId, PageForm pageForm);

    /**
     * 查询支付宝商家券活动支付页渠道
     */
    ResponseData<PageInfo<AlipayVoucherDeliveryChannelVo>> deliveryChannelQuerySelf(Long mktActivityId, PageForm pageForm);

    /**
     * 支付宝支付页渠道-报名
     */
    ResponseData<Integer> deliveryChannelCreate(AlipayVoucherDeliveryCreateVo alipayVoucherDeliveryCreateVo, SysAccountPO stageUser);

    /**
     * 支付宝支付页渠道-停止投放
     */
    ResponseData<Integer> deliveryChannelStop(AlipayVoucherDeliveryStopVo alipayVoucherDeliveryStopVo, SysAccountPO stageUser);


    /**
     * 查询支付宝会场渠道
     */
    ResponseData<PageInfo<AlipayVoucherEnrollChannelVo>> enrollChannelQuery(Long mktActivityId, PageForm pageForm);

    /**
     * 查询支付宝商家券会场渠道
     */
    ResponseData<PageInfo<AlipayVoucherEnrollChannelVo>> enrollChannelQuerySelf(Long mktActivityId, PageForm pageForm);


    /**
     * 支付宝会场渠道-报名
     */
    ResponseData<Integer> enrollChannelCreate(AlipayVoucherEnrollCreateVo alipayVoucherEnrollCreateVo, SysAccountPO stageUser);

    /**
     * 支付宝会场渠道-停止投放
     */
    ResponseData<Integer> enrollChannelStop(AlipayVoucherEnrollStopVo alipayVoucherEnrollStopVo, SysAccountPO stageUser);

    /**
     * 支付宝会场渠道-查询详情
     */
    ResponseData<AlipayVoucherEnrollDetailVo> enrollChannelQueryDetail(AlipayVoucherEnrollCreateVo alipayVoucherEnrollCreateVo, SysAccountPO stageUser);
}
