package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mktCouponIntegralExchangeServiceRpc")
public interface MktCouponIntegralExchangeServiceRpc {

    /**
     * 通过兑换编号获取兑换券详情sysCompanyId brandId 必传(单个)exchangeCode必传 (批量)exchangeCodes必传
     * @param vo
     * @return
     */
    @RequestMapping(value = "/getCouponIntegralExchangeByCode",method = RequestMethod.POST)
    ResponseData<List<MktCouponIntegralExchangePO>> getCouponIntegralExchangeByCode(@RequestBody CouponRecordVO vo);

}
