package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.Data;

import java.util.Map;

@Data
public class ActivityRegistrationSinupRecordVo {
    private boolean member;
    private boolean signin;
    private String storeName;
    private Integer signupSource;
    /**
     * 如果是别人帮自己报名的, 报名的人的姓名
     */
    private String name;
    /**
     * 如果是别人帮自己报名的, 报名的人的openid
     */
    private String wxOpenId;
    /**
     * 如果是别人帮自己报名的, 报名的人的电话
     */
    private String phone;
    private String propertyJson;

    public Map<String, Object> getProperties() {
        return JacksonUtil.json2Map(propertyJson);
    }

    public String getSignupSource() {
        switch (this.signupSource) {
            case 0:
                return "导购邀约";
            case 1:
                return "活动链接";
            default:
                return "未知来源";
        }
    }
}
