package com.bizvane.mktcenterservice.models.newmkt;

import io.swagger.models.auth.In;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动分析列表responseVo
 * @author: Liu Xinpeng
 * @create: 2020-08-07 17:15
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivityAnalyzePageResponseVo implements Serializable {





    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 开始时间  yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间  yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 进行时长(天)
     */
    private String durationTime;




    /**
     * 参与活动人数
     */
    private String activitiesPeoNum;

    /**
     * 发行优惠券(张)
     */
    private String vouNum;

    /**
     * 已核销券数
     */
    private String verificationVouNum;

    /**
     * 核销率
     */
    private String verificationVouRate;

    /**
     * 券收益
     */
    private String vouAmount;

    /**
     * 赠送积分
     */
    private String bonusPoints;


}