package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.po.MktActivityAlipayVoucherEntityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityAlipayVoucherPO;
import com.bizvane.mktcenterservice.models.po.MktActivityAlipayVoucherRecordPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.mktcenterservice.models.vo.alipayvoucher.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

public interface ActivityAlipayVoucherService {

    /**
     * 查询支付宝商家券列表
     */
    ResponseData<PageInfo<ActivityAlipayVoucherResponseVo>> getAlipayVoucherList(ActivityAlipayVoucherRequestVo requestVo);

    /**
     * 审核通过新增支付宝活动
     */
    void alipayVoucherCheckApproved(SysAccountPO stageUser, MktActivityPO mktActivityPO, MktActivityAlipayVoucherPO activityAlipayVoucherPO);

    /**
     * 新增支付宝商家券活动
     */
    ResponseData<Integer> addAlipayVoucherActivity(ActivityBO bo, SysAccountPO stageUser);

    /**
     * 查询上一次上传支付宝图片信息
     */
    ResponseData<LastAlipayVoucherImageVo> getLastImage(Long sysBrandId);

    /**
     * 停止支付宝商家券活动
     */
    ResponseData<Integer> stopAlipayVoucherActivity(ActivityVO vo, SysAccountPO stageUser);

    /**
     * 支付宝商家券新追加券
     */
    ResponseData<Integer> appendVoucher(ActivityAlipayVoucherAppendVo appendVo, SysAccountPO stageUser);

    /**
     * 查询支付宝商家券同步券进度条
     */
    ResponseData<ActivityAlipayVoucherProgressBarValueVo> getProgressBarValue(ActivityAlipayVoucherRequestVo requestVo, SysAccountPO stageUser);

    /**
     * 查询支付宝商家券详情
     */
    ResponseData<ActivityBO> selectAlipayVoucherActivityByCode(String businessCode, SysAccountPO stageUser);

    /**
     * 查询支付宝商家券-会场投放
     */
    ResponseData<PageInfo<ActivityAlipayVoucherPlanResponseVo>> getAlipayVoucherPlanList(ActivityAlipayVoucherRequestVo requestVo, SysAccountPO stageUser);

    /**
     * 查询支付宝商家券-支付成功页投放
     */
    ResponseData<PageInfo<ActivityAlipayVoucherDeliveryResponseVo>> getAlipayVoucherDeliveryList(ActivityAlipayVoucherRequestVo requestVo, SysAccountPO stageUser);

    /**
     * 支付宝商家券-支付宝活动创建成功
     */
    ResponseData<Integer> alipayVoucherCreated(AlipayVoucherCreatedVo alipayVoucherCreatedVo);

    /**
     * 支付宝商家券-支付宝活动停用成功
     */
    ResponseData<Integer> alipayVoucherStopped(AlipayVoucherStoppedVo alipayVoucherStoppedVo);

    /**
     * 支付宝商家券-券领取通知
     */
    ResponseData<Integer> alipayVoucherReceivedVo(AlipayVoucherReceivedVo alipayVoucherReceivedVo);

    /**
     * 使用支付宝活动id查询中台商家券活动
     */
    ResponseData<MktActivityAlipayVoucherPO> selectAlipayVoucherByAlipayActivityId(AlipayVoucherQueryVo alipayVoucherQueryVo);

    /**
     * 支付宝活动新增发券任务，更新记录发券任务id
     */
    ResponseData<Integer> updateAlipayVoucherRecord(AlipayVoucherRecordVo alipayVoucherRecordVo);

    /**
     * 支付宝活动券保存并上传
     */
    void saveVoucherEntityAndUpload(CouponEntityPO couponEntityPO , MktActivityAlipayVoucherRecordPO alipayVoucherRecordPO);

    /**
     * 支付宝活动-方案报名状态变更
     */
    ResponseData alipayVoucherPlanEnrollChanged(AlipayVoucherPlanEnrollChangedVo alipayVoucherPlanEnrollChangedVo);

    /**
     * 商家券活动预算追加通知
     */
    ResponseData alipayVoucherAppended(AlipayVoucherAppendedVo alipayVoucherAppendedVo);

    /**
     * 券绑定会员
     */
    ResponseData bindCoupon(MktActivityAlipayVoucherEntityPO mktActivityAlipayVoucherEntityPO, String memberCode);

    /**
     * 活动审核
     * @param
     * @return
     */
    ResponseData<Integer> checkActivityById(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 审核通过支付宝商家券活动
     */
    void alipayVoucherApproved(String activityCode, MktActivityPO mktActivityPO);

    /**
     * 查询支付宝商家券实体表(分页)
     * @param vo
     * @return
     */
    ResponseData<PageInfo<MktActivityAlipayVoucherEntityPO>> getAlipayVoucherEntity(ActivityAlipayVoucherRequestVo vo);
}
