package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道会员对应关系
 */
@Getter
/**
 * 订单支付枚举
 */
public enum ChannelMemberCodeEnum {
    ALLTYPE(100000, "全部（微信与支付宝）"),
    WX_MINI_MEMBER(100002, "微信小程序会员中心"),
    ALIPAY_MINI(100003, "支付宝小程序会员中心")
    ;

    private Integer code;
    private String message;

    ChannelMemberCodeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
