package com.bizvane.mktcenterservice.models.bo;

import com.bizvane.mktcenterservice.common.OrderCunsumeTag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author zcc
 * @date 2021/6/22 16:30
 **/
@Data
public class OrderCunsumeBo implements Serializable {
    private static final long serialVersionUID = 968405052904336488L;

    /**
     * 企业id
     */
    private Long companyId;

    /**
     * 品牌id
     */
    private Long brandId;

    /**
     * 订单来源
     */
    private Integer orderFrom;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * memberCode
     */
    private String memberCode;

    /**
     * 订单支付金额
     */
    private BigDecimal payMoney;

    /**
     * 订单支付时间
     */
    private Date payTime;

    /**
     * 订单服务门店id
     */
    private Long serviceStoreId;

    /**
     * 订单服务门店code
     */
    private String serviceStoreCode;

    /**
     * 商品编码
     */
    private List<String> productNoList;

    /**
     * 消费tag
     */
    private OrderCunsumeTag orderCunsumeTag;
}
