package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.po.MktContentChannelSourceActionPo;
import com.bizvane.mktcenterservice.models.vo.MemberChannelSourceDetailVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/membersSourceRpc")
public interface MemberSourceServiceRpc {

    /**
     * 查询 会员特定动作/事件 的来源信息
     * @param sysBrandId 品牌id
     * @param memberCode 会员编号
     * @param actionTypes 会员的动作/事件类型：1.浏览，2.注册/绑定，3点亮俱乐部
     * @return
     */
    @PostMapping("getMembersSourceByMemberCodeAndActionType")
    MktContentChannelSourceActionPo getMembersSourceByMemberCodeAndActionType(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode, @RequestParam("actionTypes") Integer[] actionTypes);

    /**
     * 分页查询 会员渠道记录明细
     * @param requestVo
     * @return
     */
    @PostMapping("getMemberAllSourceActionInfo")
    ResponseData<PageInfo<MktContentChannelSourceActionPo>> getMemberAllSourceActionInfo(@RequestBody MemberChannelSourceDetailVO requestVo);
}
