package com.bizvane.mktcenterservice.models.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zcc
 * @date 2021/11/23 14:36
 **/
@Data
public class MktContentSearchVo implements Serializable {

    private static final long serialVersionUID = -7938679050073399591L;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 投放内容编码
     */
    private String contentCode;

    /**
     * 投放内容名称
     */
    private String contentName;

    /**
     * 内容类型：1.微信会员中心小程序 2.微信公众号 3.外部系统功能'
     */
    private Integer contentType;

    /**
     * 投放渠道名称
     */
    private List<String> channelNames;

    /**
     * 内容投放状态：1.生成中 2.投放中 3.已终止
     */
    private Integer status;

    /**
     * 创建人名称
     */
    private String createName;

    private Integer pageNumber;

    private Integer pageSize;
}
