package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.MktContentBo;
import com.bizvane.mktcenterservice.models.vo.MktContentSearchVo;
import com.bizvane.mktcenterservice.models.vo.MktContentVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

/**
 * 内容推广Service
 **/
public interface MktContentService {
    /**
     * 新增
     * @param mktContentBo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> add(MktContentBo mktContentBo, SysAccountPO sysAccountPO);

    /**
     * 分页
     * @param mktContentSearchVo
     * @param sysAccountPO
     * @return
     */
    ResponseData<PageInfo<MktContentVo>> page(MktContentSearchVo mktContentSearchVo, SysAccountPO sysAccountPO);

    /**
     * 编辑
     * @param mktContentBo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> update(MktContentBo mktContentBo, SysAccountPO sysAccountPO);

    /**
     * 推广内容操作
     * @param operateType
     * @param mktContentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> operate(Integer operateType, Long mktContentId, SysAccountPO sysAccountPO);

    /**
     * 详情
     * @param mktContentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<MktContentBo> getById(Long mktContentId, SysAccountPO sysAccountPO);

    /**
     * 终止内容推广
     * @param mktContentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> updateStop(Long mktContentId, SysAccountPO sysAccountPO);

    /**
     * 导出内容推广
     * @param mktContentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> exportContent(Long mktContentId, SysAccountPO sysAccountPO);
}
