package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityRegistrationBO;
import com.bizvane.mktcenterservice.models.bo.TMktActivitySignup;
import com.bizvane.mktcenterservice.models.vo.ActivityRegistrationVO;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @author zhaoxh
 */
@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityRegistrationRpc")
public interface ActivityRegistrationServiceRpc {
    /**
     * 查询活动详情
     */
    @PostMapping("/detail")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityCode", value = "活动代码")})
    ResponseData<ActivityRegistrationBO> getActivityRegistrationDetail(@RequestParam("activityCode") String activityCode);

    @PostMapping("/signup")
    ResponseData<Object> signup(@RequestBody TMktActivitySignup activitySignup);


    @PostMapping("/signuped")
    ResponseData<Boolean> signuped(@RequestParam String activityCode, @RequestParam("memberCode") String memberCode);

    @PostMapping("/getByActivityCodeAndPhone")
    ResponseData<List<TMktActivitySignup>> getByActivityCodeAndPhone(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone);

    @RequestMapping(value = "/signupHistory",method = RequestMethod.GET)
    ResponseData<PageInfo<SignupHistory>> signupHistory(@RequestParam("memberCode") String memberCode,
                                                        @RequestParam(value = "activityCode",required = false) String activityCode,
                                                        @RequestParam(value = "pageNum",required = false,defaultValue = "0") Integer pageNum,
                                                        @RequestParam(value = "pageSize",required = false,defaultValue = "0") Integer pageSize);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "memberCode", value = "帮报名会员code/导购code"),
            @ApiImplicitParam(name = "helpShoppingGuideId", value = "导购id"),
            @ApiImplicitParam(name = "pageNum", value = "起始页"),
            @ApiImplicitParam(name = "pageSize", value = "页数"),
    })
    @RequestMapping(value = "/helpSignupHistory",method = RequestMethod.GET)
    public ResponseData<Map<String,Object>> helpSignupHistory(@RequestParam("memberCode") String memberCode,
                                                              @RequestParam(value = "helpShoppingGuideId",required = false)Long helpShoppingGuideId,
                                                              @RequestParam(value = "activityCode",required = false) String activityCode,
                                                              @RequestParam(value = "pageNum",required = false,defaultValue = "0") Integer pageNum,
                                                              @RequestParam(value = "pageSize",required = false,defaultValue = "0") Integer pageSize);

    @PostMapping("/signin")
    ResponseData<Object> signin(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone,
                                @RequestParam(value = "memberCode",required = false) String memberCode,
                                @RequestParam(value = "sysCompanyId",required = false) Long sysCompanyId,
                                @RequestParam(value = "brandId",required = false) Long brandId);

    @PostMapping("/isSigninByactivityCodeAndphone")
    ResponseData isSigninByactivityCodeAndphone(@RequestParam("activityCode") String activityCode,
                                                @RequestParam("phone") String phone);


    //商秀帮人报名
    @ApiOperation(value = "帮人报名")
    @PostMapping("helpSignupByOther")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityCode", value = "活动代码"),
            @ApiImplicitParam(name = "customProperties", value = "报名资料的json,包含，key为propertyName，value为填写的值 如{\"手机号\":\"123****1234\",\"姓名\":\"王小明\"}"),
            @ApiImplicitParam(name = "signUpSource", value = "0:自己报名 1：帮别人报名 2:签到报名" ),
            @ApiImplicitParam(name = "signUpOrigin", value = "报名来源 1:会员中心 2:商秀"),
            @ApiImplicitParam(name = "helpMemberCode", value = "帮报名会员code/导购code"),
            @ApiImplicitParam(name = "helpShoppingGuideId", value = "导购id"),
            @ApiImplicitParam(name = "sysCompanyId", value = "企业"),
            @ApiImplicitParam(name = "sysBrandId", value = "品牌"),
    })
    ResponseData<Object> helpSignupByOther(
            @RequestParam(value = "activityCode") String activityCode,
            @RequestParam(value = "customProperties")String customProperties,
            @RequestParam(value = "signUpSource",required = false,defaultValue = "1")Byte signUpSource,
            @RequestParam(value = "signUpOrigin",required = false,defaultValue = "2")Byte signUpOrigin,
            @RequestParam(value = "helpMemberCode",required = false)String helpMemberCode,
            @RequestParam(value = "helpShoppingGuideId",required = false)Long helpShoppingGuideId,
            @RequestParam(value = "sysCompanyId",required = false)Long sysCompanyId,
            @RequestParam(value = "sysBrandId",required = false)Long sysBrandId);


    //商秀
    @ApiOperation(value = "上传图片和文字")
    @PostMapping("uploadPhoto")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityCode", value = "活动代码"),
            @ApiImplicitParam(name = "literalContent",required = false, value = "文字" ),
            @ApiImplicitParam(name = "photoUrl", required = false,value = "图片链接 多个用','拼接" ),
            @ApiImplicitParam(name = "sysCompanyId", value = "企业"),
            @ApiImplicitParam(name = "brandId", value = "品牌"),
    })
    ResponseData<Object> uploadPhoto(@RequestParam(value = "activityCode") String activityCode,
                                            @RequestParam(value = "literalContent",required = false)String literalContent,
                                            @RequestParam(value = "photoUrl",required = false)String photoUrl,
                                            @RequestParam(value = "sysCompanyId",required = false)Long sysCompanyId,
                                            @RequestParam(value = "sysBrandId",required = false)Long sysBrandId);

    //商秀
    @ApiOperation(value = "获取报名活动列表")
    @GetMapping("getActivityRegistrationList")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityCode",required = false, value = "活动代码"),
            @ApiImplicitParam(name = "storeId",required = false, value = "仓店id" ),
            @ApiImplicitParam(name = "activityStatus",required = false, value = "活动状态" ),
            @ApiImplicitParam(name = "sysCompanyId", value = "企业"),
            @ApiImplicitParam(name = "sysbrandId", value = "品牌"),
            @ApiImplicitParam(name = "pageNum", value = "开始页"),
            @ApiImplicitParam(name = "pageSize", value = "页数")
    })
    ResponseData<PageInfo<ActivityRegistrationVO>> getActivityRegistrationlist(@RequestParam(value = "activityCode",required = false) String activityCode,
                                                                               @RequestParam(value = "storeId",required = false)Long storeId,
                                                                               @RequestParam(value = "activityStatus",required = false)Integer activityStatus,
                                                                               @RequestParam(value = "sysCompanyId",required = false)Long sysCompanyId,
                                                                               @RequestParam(value = "sysbrandId",required = false)Long sysbrandId,
                                                                               @RequestParam(value = "pageNum",required = false)Integer pageNum,
                                                                               @RequestParam(value = "pageSize",required = false)Integer pageSize);

}
