package com.bizvane.mktcenterservice.interfaces;


import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vg.VGActivityVo;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;


public interface ActivityManualService {

  ResponseData<ActivityVO> getActivityManualList(ActivityVO vo , PageForm pageForm,SysAccountPO stageUser);

  ResponseData<Integer> addActivityManual(ActivityBO bo,SysAccountPO stageUser);

  ResponseData<Integer> updateActivityManual(ActivityBO bo, SysAccountPO stageUser);

  ResponseData<ActivityManualVO> executeActivity(ActivityManualVO vo);

  ResponseData<ActivityManualVO> executeActivityScanVG(ActivityManualVO vo);

  ResponseData<ActivityManualVO> executeActivityVGV2(ActivityManualVO vo);

  ResponseData<ActivityManualVO> subscribeActivityVG(ActivityManualVO vo);

  ResponseData<List<ActivityBO>> getActivityManualEffect(ActivityVO vo);

  ResponseData<ActivityBO> selectActivityManualByBusinessCode(String businessCode);

  ResponseData<List<ActivityVO>>  getActivityByMemberInfo(MemberInfoModel memberInfoModel,Integer activityType);

  ResponseData<ArrayList<ActivityVO>>  getActivityByQrcode(MemberInfoModel memberInfoModel, String activityCode, Integer activityType);

  ResponseData<Integer>  checkActivity(SysCheckPo po, SysAccountPO sysAccountPO);

  ResponseData validateActivity(ActivityManualVO vo);

  ResponseData<List<ActivityVO>>  getActivityByMemberInfoVg(MemberInfoModel memberInfoModel, Integer activityType);

  ResponseData<ArrayList<ActivityVO>>  getActivityByQrcodeVg(MemberInfoModel memberInfoModel, String activityCode, Integer activityType);

  ResponseData<List<VGActivityVo>>  getActivityByMemberInfoVgV2(ActivityManualVO vo);

  ResponseData<ArrayList<VGActivityVo>>  getActivityByQrcodeVgV2(ActivityManualVO vo);


}
