package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.po.MktTaskPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.TaskDetailVO;
import com.bizvane.mktcenterservice.models.vo.TaskSearchVO;
import com.bizvane.mktcenterservice.models.vo.WhiteStoreVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2018/11/5 13:53
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskRpc")
public interface TaskServiceRpc {
    @RequestMapping("getWhiteStoreIds")
    public List<Long> getWhiteStoreIds(@RequestBody WhiteStoreVO vo);

    @RequestMapping("getTaskDetailByTaskId")
    public TaskDetailVO getTaskDetailByTaskId(Long taskId);

    @PostMapping("getTaskByTaskType")
    public ResponseData<PageInfo<MktTaskPOWithBLOBs>> getTaskByTaskType(@RequestBody TaskSearchVO vo);

}

