/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.beust.jcommander.internal.Maps;
import com.bizvane.message.cache.ChannelCacheComponent;
import com.bizvane.message.component.MessageAccount;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.dao.ChannelDao;
import com.bizvane.message.entity.Channel;
import com.bizvane.message.service.inter.IChannelService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelService
implements IChannelService {
    private static final Logger log = LoggerFactory.getLogger(ChannelService.class);
    @Autowired
    private ChannelDao channelDao;
    @Autowired
    private ChannelCacheComponent component;

    public Channel saveChannel(String merchantId, String channelName, String channelType, String accountJson) {
        MessageAccount messageAccount = (MessageAccount)JSON.parseObject((String)accountJson, MessageAccount.class);
        if (messageAccount == null || StringUtils.isBlank((CharSequence)messageAccount.getType())) {
            return null;
        }
        ArrayList<MessageAccount> aList = new ArrayList<MessageAccount>();
        aList.add(messageAccount);
        Channel channel = this.channelDao.get(merchantId, channelType);
        if (channel == null) {
            channel = new Channel();
            channel.setMerchantId(merchantId);
            channel.setChannelId(merchantId.concat("_").concat(channelType));
            channel.setAccountJson(JSON.toJSONString(aList));
            channel.setChannelType(channelType);
            channel.setChannelName(channelName);
            channel.setCreateTime(new Date());
            channel.setUpdateTime(new Date());
            this.channelDao.insert((Object)channel);
            this.component.save(channel);
            return channel;
        }
        List accounts = JSON.parseArray((String)channel.getAccountJson(), MessageAccount.class);
        Map map = Maps.newHashMap();
        for (int i = 0; i < accounts.size(); ++i) {
            MessageAccount account = (MessageAccount)accounts.get(i);
            map.put(account.getType(), account);
        }
        map.put(messageAccount.getType(), messageAccount);
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        this.channelDao.deleteByMerchanId(merchantId, channelType);
        channel = new Channel();
        channel.setMerchantId(merchantId);
        channel.setChannelId(merchantId.concat("_").concat(channelType));
        channel.setAccountJson(JSON.toJSONString(list));
        channel.setChannelType(channelType);
        channel.setChannelName(channelName);
        channel.setCreateTime(new Date());
        channel.setUpdateTime(new Date());
        this.channelDao.insert((Object)channel);
        channel.setAccountJson(JSON.toJSONString(aList));
        this.component.save(channel);
        return channel;
    }

    public Channel updateChannelOnlyPassnameAndPwd(String merchantId, String channelName, String channelType, String accountJson) throws MessageException {
        MessageAccount paramMessageAccount = (MessageAccount)JSON.parseObject((String)accountJson, MessageAccount.class);
        if (paramMessageAccount == null || StringUtils.isBlank((CharSequence)paramMessageAccount.getType())) {
            return null;
        }
        String type = paramMessageAccount.getType();
        log.info("\u66f4\u65b0\u7684\u5165\u53c2type\u662f:{}", (Object)type);
        Channel channel = this.channelDao.get(merchantId, channelType);
        if (channel == null) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.CHANNEL_CONFIG_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.CHANNEL_CONFIG_ERROR.getErrCodeDes()).build();
        }
        List accounts = JSON.parseArray((String)channel.getAccountJson(), MessageAccount.class);
        Map map = Maps.newHashMap();
        for (int i = 0; i < accounts.size(); ++i) {
            MessageAccount account = (MessageAccount)accounts.get(i);
            map.put(account.getType(), account);
        }
        MessageAccount temp = (MessageAccount)map.get(type);
        if (temp == null) {
            throw MessageException.newBuilder().errCode("1021").errCodeDes("\u6e20\u9053\u4e2d\u5e76\u6ca1\u6709\u4e00\u4e2a\u53eb<" + type + ">\u7684\u5b50\u8d26\u6237\uff0c\u8bf7\u68c0\u67e5\u4f60\u7684\u6e20\u9053\u8bbe\u7f6e").build();
        }
        MessageAccount messageAccount = new MessageAccount();
        BeanUtils.copyProperties((Object)temp, (Object)messageAccount);
        messageAccount.setAccessKeyId(paramMessageAccount.getAccessKeyId());
        messageAccount.setSecret(paramMessageAccount.getSecret());
        messageAccount.setDeepPassword(paramMessageAccount.getDeepPassword());
        messageAccount.setDeepUsername(paramMessageAccount.getDeepUsername());
        messageAccount.setSubid(paramMessageAccount.getSubid());
        ArrayList<MessageAccount> aList = new ArrayList<MessageAccount>();
        aList.add(messageAccount);
        map.put(messageAccount.getType(), messageAccount);
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        this.channelDao.updatePassNameAndPwdById(merchantId, channelType, JSON.toJSONString(list));
        channel = new Channel();
        channel.setMerchantId(merchantId);
        channel.setChannelId(merchantId.concat("_").concat(channelType));
        channel.setAccountJson(JSON.toJSONString(aList));
        channel.setChannelType(channelType);
        channel.setChannelName(channelName);
        channel.setCreateTime(new Date());
        channel.setUpdateTime(new Date());
        this.component.save(channel);
        channel.setAccountJson(JSON.toJSONString(aList));
        return channel;
    }

    public List<Channel> findByMerchantId(String merchantId) {
        List list = this.channelDao.findByMerchantId(merchantId);
        return list;
    }
}

