/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.utils;

import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.ChannleTypeEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.TemplateTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannelSuffixConverter {
    private static final Logger log = LoggerFactory.getLogger(MessageChannelSuffixConverter.class);

    public static String getSuitableSuffix(String channelType, String templateType) throws MessageException {
        String result = null;
        if (ChannleTypeEnum.getSuffixByChannleType((String)channelType).booleanValue()) {
            TemplateTypeEnum[] values;
            for (TemplateTypeEnum v : values = TemplateTypeEnum.values()) {
                if (!v.getValue().equals(templateType)) continue;
                result = v.getDesc();
                break;
            }
            if (StringUtils.isBlank(result)) {
                throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCodeDes()).build();
            }
        }
        return result;
    }
}

