package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum RechargeBalanceChangeFieldEnum {

    FIELD_1("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_CARD_NO, "FIELD_RECHARGE_CARD_NO", Boolean.TRUE),
    FIELD_2("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_AMOUNT, "FIELD_RECHARGE_AMOUNT", Boolean.TRUE),
    FIELD_3("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_BALANCE, "FIELD_RECHARGE_BALANCE", Boolean.TRUE),
    FIELD_4("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.RECHARGE_TIME, "FIELD_RECHARGE_TIME", Boolean.TRUE),
    FIELD_5("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    RechargeBalanceChangeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    RechargeBalanceChangeFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(RechargeBalanceChangeFieldEnum.values()).filter(e -> e.getMustNotNull()).map(RechargeBalanceChangeFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(RechargeBalanceChangeFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), RechargeBalanceChangeFieldEnum::getJsonField, (a, b) -> b));
    }

}
