package com.bizvane.messagefacade.enums;

public enum WeChatAppletSubscribeTopicEnum {

    REQUEST_SUBSCRIBE_MESSAGE("request_subscribe_message", WeChatAppletSubscribeTopicEnum.TOPIC_NAME, WeChatAppletSubscribeTopicEnum.TAG_NAME_REQUEST_CLICK),
    SUBSCRIBE_MSG_POPUP_EVENT("subscribe_msg_popup_event", WeChatAppletSubscribeTopicEnum.TOPIC_NAME, WeChatAppletSubscribeTopicEnum.TAG_NAME_POPUP),
    SUBSCRIBE_MSG_CHANGE_EVENT("subscribe_msg_change_event", WeChatAppletSubscribeTopicEnum.TOPIC_NAME, WeChatAppletSubscribeTopicEnum.TAG_NAME_CHANGE),
    SUBSCRIBE_MSG_SENT_EVENT("subscribe_msg_sent_event", WeChatAppletSubscribeTopicEnum.TOPIC_NAME, WeChatAppletSubscribeTopicEnum.TAG_NAME_SENT);


    private String event;

    private String topic;

    private String tag;

    public final static String TOPIC_NAME = "wechat_applet_subscribe";
    public final static String TAG_NAME_POPUP = "subscribe_msg_popup_event";
    public final static String TAG_NAME_CHANGE = "subscribe_msg_change_event";
    public final static String TAG_NAME_SENT = "subscribe_msg_sent_event";
    public final static String TAG_NAME_REQUEST_CLICK = "request_subscribe_message";

    WeChatAppletSubscribeTopicEnum(String event, String topic, String tag) {
        this.event = event;
        this.topic = topic;
        this.tag = tag;
    }

    public String getEvent() {
        return event;
    }

    public String getTopic() {
        return topic;
    }

    public String getTag() {
        return tag;
    }
}
