package com.bizvane.messagefacade.interfaces;

import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.messagefacade.models.dto.SmsTemplateDto;
import com.bizvane.messagefacade.models.vo.SmsTemplateVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 获取短信模板
 * @author Bizvane
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/smsTemplate")
public interface SmsTemplateServiceFeign {

    /**
     *  根据模板code 和当前登陆用户信息获取短信模板
     * @param smsTemplateVo
     * @return
     */
    @PostMapping(value = "/getTemplateRpc")
    ResponseData<TemplateDto> getTemplate(@RequestBody SmsTemplateVo smsTemplateVo);

    /**
     * 获取短信发送模板列表(支持多个商户号) RPC
     */
    @PostMapping("/pageListMultiSmsSendTemplate")
    ResponseData<ListResultBean<SmsTemplateDto>> pageListMultiSmsSendTemplate(@RequestBody SmsTemplateVo smsTemplateVo);


}
