/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.message.api.model.dto.MsgWxMiniSubscribeRecordFindDTO;
import com.bizvane.message.api.model.dto.WxMiniSubscribeSendBusinessDTO;
import com.bizvane.message.api.service.MsgWxMiniSubscribeBusinessService;
import com.bizvane.message.domain.model.entity.MsgWxMiniProTempPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeParamPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeRecordPO;
import com.bizvane.message.domain.model.entity.MsgWxMiniSubscribeSentRecordPO;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeParamService;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeRecordService;
import com.bizvane.message.domain.service.IMsgWxMiniSubscribeSentRecordService;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.enums.msg.MsgTemplateTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MsgWxMiniSubscribeBusinessServiceImpl
implements MsgWxMiniSubscribeBusinessService {
    private final IMsgWxMiniSubscribeRecordService msgWxMiniSubscribeRecordService;
    private final IMsgWxMiniSubscribeParamService msgWxMiniSubscribeParamService;
    private final IMsgWxMiniSubscribeSentRecordService msgWxMiniSubscribeSentRecordService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSentRecord(WxMiniSubscribeSendBusinessDTO wxMiniSubscribeSendBusinessDTO) {
        MsgWxMiniSubscribeRecordPO subscribeRecord = wxMiniSubscribeSendBusinessDTO.getSubscribeRecord();
        MsgWxMiniProTempPO msgWxMiniProTempPO = wxMiniSubscribeSendBusinessDTO.getMsgWxMiniProTempPO();
        MsgWxMiniSubscribeParamPO subscribeParamPO = this.msgWxMiniSubscribeParamService.selectOneByCode(subscribeRecord.getMsgWxMiniSubscribeParamCode());
        MsgWxMiniSubscribeSentRecordPO msgWxMiniSubscribeSentRecordPO = new MsgWxMiniSubscribeSentRecordPO();
        msgWxMiniSubscribeSentRecordPO.setMsgWxMiniSubscribeSentRecordCode(UID.getUid());
        msgWxMiniSubscribeSentRecordPO.setMsgWxMiniSubscribeRecordCode(subscribeRecord.getMsgWxMiniSubscribeRecordCode());
        msgWxMiniSubscribeSentRecordPO.setMktMassTaskCode(subscribeParamPO.getMktMassTaskCode());
        msgWxMiniSubscribeSentRecordPO.setMemberCode(subscribeParamPO.getMemberCode());
        msgWxMiniSubscribeSentRecordPO.setMemberName("memberName");
        msgWxMiniSubscribeSentRecordPO.setCardNo("cardNo");
        msgWxMiniSubscribeSentRecordPO.setPhone("phone");
        msgWxMiniSubscribeSentRecordPO.setTemplateType(subscribeRecord.getTemplateType());
        msgWxMiniSubscribeSentRecordPO.setOpenId(subscribeRecord.getFromUserName());
        msgWxMiniSubscribeSentRecordPO.setSentStatus("sentStatus");
        msgWxMiniSubscribeSentRecordPO.setErrorCode("errorCode");
        msgWxMiniSubscribeSentRecordPO.setErrorMsg("errorMsg");
        msgWxMiniSubscribeSentRecordPO.setWxTempId(msgWxMiniProTempPO.getWxTempId());
        msgWxMiniSubscribeSentRecordPO.setWxTempTitle(msgWxMiniProTempPO.getWxTempTitle());
        boolean isSuccess = true;
        if (isSuccess) {
            msgWxMiniSubscribeSentRecordPO.setSentStatus("success");
        } else {
            String sentMessage = "{}";
            msgWxMiniSubscribeSentRecordPO.setSentStatus("fail");
            msgWxMiniSubscribeSentRecordPO.setSentMessage(sentMessage);
            JSONObject jsonObject = JSON.parseObject((String)sentMessage);
            msgWxMiniSubscribeSentRecordPO.setErrorCode(jsonObject.getString("errcode"));
            msgWxMiniSubscribeSentRecordPO.setErrorMsg(jsonObject.getString("errmsg"));
        }
        boolean sentRecordResult = this.msgWxMiniSubscribeSentRecordService.save((Object)msgWxMiniSubscribeSentRecordPO);
        boolean recordResult = this.msgWxMiniSubscribeRecordService.updateSentStatusByCode(msgWxMiniSubscribeSentRecordPO.getSentStatus(), subscribeRecord.getMsgWxMiniSubscribeRecordCode());
        if (recordResult) {
            boolean bl = this.msgWxMiniSubscribeParamService.updateSentStatusByCode(msgWxMiniSubscribeSentRecordPO.getSentStatus(), subscribeParamPO.getMsgWxMiniSubscribeParamCode());
        }
    }

    @Override
    public MsgWxMiniSubscribeRecordPO findSubscribeRecord(MsgWxMiniSubscribeRecordFindDTO paramDto) {
        LambdaQueryWrapper<MsgWxMiniSubscribeParamPO> paramQueryWrapper = this.builderQueryWrapper(paramDto);
        List paramPOList = this.msgWxMiniSubscribeParamService.list(paramQueryWrapper);
        LambdaQueryWrapper recordQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgWxMiniSubscribeRecordPO::getTemplateType, (Object)paramDto.getTemplateType())).eq(MsgWxMiniSubscribeRecordPO::getFromUserName, (Object)paramDto.getOpenId())).eq(MsgWxMiniSubscribeRecordPO::getSubscribeStatus, (Object)"accept")).last("limit 1");
        if (CollectionUtils.isEmpty((Collection)paramPOList)) {
            recordQueryWrapper.isNull(MsgWxMiniSubscribeRecordPO::getMsgWxMiniSubscribeParamCode);
        } else {
            List paramCodeList = paramPOList.stream().map(MsgWxMiniSubscribeParamPO::getMsgWxMiniSubscribeParamCode).collect(Collectors.toList());
            recordQueryWrapper.in(MsgWxMiniSubscribeRecordPO::getMsgWxMiniSubscribeParamCode, paramCodeList);
        }
        return (MsgWxMiniSubscribeRecordPO)this.msgWxMiniSubscribeRecordService.getOne((Wrapper)recordQueryWrapper);
    }

    private LambdaQueryWrapper<MsgWxMiniSubscribeParamPO> builderQueryWrapper(MsgWxMiniSubscribeRecordFindDTO paramDto) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgWxMiniSubscribeParamPO::getFromUserName, (Object)paramDto.getOpenId())).isNull(MsgWxMiniSubscribeParamPO::getSentStatus);
        JSONObject businessParamJson = paramDto.getBusinessParamJson();
        String templateType = paramDto.getTemplateType();
        if (!(MsgTemplateTypeEnum.isTask((String)templateType) || MsgTemplateTypeEnum.isActivity((String)templateType) || MsgTemplateTypeEnum.isCoupon((String)templateType))) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.isNull(MsgWxMiniSubscribeParamPO::getActivityCode)).isNull(MsgWxMiniSubscribeParamPO::getTaskCode)).isNull(MsgWxMiniSubscribeParamPO::getCouponCode);
            return queryWrapper;
        }
        if (businessParamJson.containsKey((Object)"activityCode") && MsgTemplateTypeEnum.isActivity((String)templateType)) {
            queryWrapper.eq(MsgWxMiniSubscribeParamPO::getActivityCode, (Object)businessParamJson.getString("activityCode"));
        }
        if (businessParamJson.containsKey((Object)"taskCode") && MsgTemplateTypeEnum.isTask((String)templateType)) {
            queryWrapper.eq(MsgWxMiniSubscribeParamPO::getTaskCode, (Object)businessParamJson.getString("taskCode"));
        }
        if (businessParamJson.containsKey((Object)"couponCode") && MsgTemplateTypeEnum.isCoupon((String)templateType)) {
            queryWrapper.eq(MsgWxMiniSubscribeParamPO::getCouponCode, (Object)businessParamJson.getString("couponCode"));
        }
        return queryWrapper;
    }

    public MsgWxMiniSubscribeBusinessServiceImpl(IMsgWxMiniSubscribeRecordService msgWxMiniSubscribeRecordService, IMsgWxMiniSubscribeParamService msgWxMiniSubscribeParamService, IMsgWxMiniSubscribeSentRecordService msgWxMiniSubscribeSentRecordService) {
        this.msgWxMiniSubscribeRecordService = msgWxMiniSubscribeRecordService;
        this.msgWxMiniSubscribeParamService = msgWxMiniSubscribeParamService;
        this.msgWxMiniSubscribeSentRecordService = msgWxMiniSubscribeSentRecordService;
    }
}

