/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.message.api.model.dto.MsgSmsTemplateRemoteAddRequestParam;
import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.dto.template.MsgSmsTemplateRemoteQueryRequestParam;
import com.bizvane.message.api.model.dto.template.sms.MsgSmsMultiListSendTemplateRequestParam;
import com.bizvane.message.api.model.vo.template.sms.MsgSmsTempEditRequestParam;
import com.bizvane.message.api.model.vo.template.sms.MsgSmsTempSaveRequestParam;
import com.bizvane.message.api.service.MsgSmsTemplateService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.service.RemoteTemplateWrapperService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.domain.model.bo.MsgSmsTempQueryBO;
import com.bizvane.message.domain.model.entity.MsgSmsTempPO;
import com.bizvane.message.domain.service.IMsgSmsTempService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgSmsTemplateServiceImpl
implements MsgSmsTemplateService {
    private final OptUserService optUserService;
    private final IMsgSmsTempService msgSmsTempService;
    private final RemoteTemplateWrapperService remoteTemplateWrapperService;

    @Override
    public ResponseData<ListResultBean<? extends TemplateDto>> multiListSendTemplate(MsgSmsMultiListSendTemplateRequestParam requestParam) {
        String merchantIds = this.remoteTemplateWrapperService.getMerchantIds();
        ListResultBean<TemplateDto> resultBean = this.remoteTemplateWrapperService.getTemplateDtoListResultBean(requestParam, merchantIds);
        return new ResponseData(resultBean);
    }

    @Override
    public ResponseData<Boolean> insertMsgSmsTemp(MsgSmsTempSaveRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getBusinessType(), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull(requestParam.getTemplateType(), "\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull((Object)requestParam.getStatus(), "\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull(requestParam.getTemplateCodeCn(), "\u8bf7\u9009\u62e9\u56fd\u5185\u77ed\u4fe1\u6a21\u677f!");
        AssertUtil.notNull((Object)requestParam.getSendWxmember(), "0.\u5168\u90e8\u53d1\u9001 1.\u5411\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe12.\u5411\u975e\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe1,\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MsgTemplateTypeEnum templateTypeEnum = MsgTemplateTypeEnum.getByCode((String)requestParam.getTemplateType());
        AssertUtil.notNull((Object)templateTypeEnum, "\u6a21\u677f\u7c7b\u578b\u4e0d\u5b58\u5728");
        MsgSmsTempPO msgSmsTempPOByTemplateType = this.getMsgSmsTempPOByTemplateType(requestParam.getTemplateType(), templateTypeEnum.getBusinessTypeEnum().getCode());
        if (msgSmsTempPOByTemplateType != null) {
            return ResponseUtil.fail((String)"\u8be5\u54c1\u724c\u7684\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01\u4e0d\u5141\u8bb8\u91cd\u590d");
        }
        OptUserDTO optUser = this.optUserService.getOptUser();
        Boolean result = this.saveMsgSmsTempPO(requestParam, optUser);
        return ResponseUtil.success((Object)result);
    }

    @Override
    public ResponseData<Boolean> updateMsgSmsTemp(MsgSmsTempEditRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getBusinessType(), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull(requestParam.getTemplateType(), "\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull((Object)requestParam.getStatus(), "\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.notNull(requestParam.getTemplateCodeCn(), "\u8bf7\u9009\u62e9\u56fd\u5185\u77ed\u4fe1\u6a21\u677f!");
        AssertUtil.notNull((Object)requestParam.getSendWxmember(), "0.\u5168\u90e8\u53d1\u9001 1.\u5411\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe12.\u5411\u975e\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe1,\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.notNull(requestParam.getMsgSmsTempCode(), "\u4e1a\u52a1code\u4e0d\u80fd\u4e3a\u7a7a");
        OptUserDTO optUser = this.optUserService.getOptUser();
        Boolean result = this.updateMsgSmsTempPO(requestParam, optUser);
        return ResponseUtil.success((Object)result);
    }

    @Override
    public ResponseData<TemplateDto> getTemplateFromRemote(MsgSmsTemplateRemoteQueryRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getTemplateCode());
        return this.remoteTemplateWrapperService.getRemoteTemplateByTemplateCode(requestParam);
    }

    @Override
    public ResponseData<TemplateDto> addRemoteTemplate(MsgSmsTemplateRemoteAddRequestParam requestParam) {
        return this.remoteTemplateWrapperService.addTemplate(requestParam);
    }

    private Boolean updateMsgSmsTempPO(MsgSmsTempEditRequestParam requestParam, OptUserDTO optUser) {
        MsgSmsTempPO msgSmsTempPO = new MsgSmsTempPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgSmsTempPO);
        msgSmsTempPO.setModifiedUserCode(optUser.getOptUserCode());
        msgSmsTempPO.setModifiedUserName(optUser.getOptUserName());
        return this.msgSmsTempService.updateOne(msgSmsTempPO);
    }

    private Boolean saveMsgSmsTempPO(MsgSmsTempSaveRequestParam requestParam, OptUserDTO optUser) {
        MsgSmsTempPO msgSmsTempPO = new MsgSmsTempPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgSmsTempPO);
        msgSmsTempPO.setCreateDate(LocalDateTime.now());
        msgSmsTempPO.setCreateUserCode(optUser.getOptUserCode());
        msgSmsTempPO.setCreateUserName(optUser.getOptUserName());
        msgSmsTempPO.setMsgSmsTempCode(UID.getUid());
        return this.msgSmsTempService.saveOne(msgSmsTempPO);
    }

    private MsgSmsTempPO getMsgSmsTempPOByTemplateType(String templateType, String businessType) {
        MsgSmsTempQueryBO msgSmsTempQueryBO = new MsgSmsTempQueryBO();
        msgSmsTempQueryBO.setTemplateType(templateType);
        msgSmsTempQueryBO.setBusinessType(businessType);
        return this.msgSmsTempService.selectOne(msgSmsTempQueryBO);
    }

    public MsgSmsTemplateServiceImpl(OptUserService optUserService, IMsgSmsTempService msgSmsTempService, RemoteTemplateWrapperService remoteTemplateWrapperService) {
        this.optUserService = optUserService;
        this.msgSmsTempService = msgSmsTempService;
        this.remoteTemplateWrapperService = remoteTemplateWrapperService;
    }
}

