/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.message.api.model.dto.config.OptUserDTO;
import com.bizvane.message.api.model.dto.template.MsgTemplateRemindQueryRequestParam;
import com.bizvane.message.api.model.dto.template.sms.MsgTemplateRemindSaveRequestParam;
import com.bizvane.message.api.model.vo.template.MsgRemindVO;
import com.bizvane.message.api.service.MsgRemindService;
import com.bizvane.message.api.service.OptUserService;
import com.bizvane.message.api.util.AssertUtil;
import com.bizvane.message.api.util.ConvertUtil;
import com.bizvane.message.domain.enums.msg.MsgSendTimeTemplateTypeMap;
import com.bizvane.message.domain.model.entity.MsgRemindPO;
import com.bizvane.message.domain.service.IMsgRemindService;
import com.bizvane.message.domain.util.ResponseUtil;
import com.bizvane.message.domain.util.UID;
import com.bizvane.message.feign.vo.remind.MsgRemindDetailRequestVO;
import com.bizvane.message.feign.vo.remind.MsgRemindDetailResponseVO;
import com.bizvane.message.feign.vo.remind.MsgRemindUpdateRequestVO;
import com.bizvane.message.feign.vo.remind.MsgRemindUpdateResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgRemindWrapperServiceImpl
implements MsgRemindService {
    private final IMsgRemindService msgRemindService;
    private final OptUserService optUserService;

    @Override
    public ResponseData<MsgRemindVO> getMsgRemind(MsgTemplateRemindQueryRequestParam requestParam) {
        AssertUtil.notNull(requestParam.getTemplateType());
        AssertUtil.judge(MsgSendTimeTemplateTypeMap.containsKey((Object)requestParam.getTemplateType()), "templateType\u4e0d\u5b58\u5728!");
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestParam.getTemplateType());
        MsgRemindVO result = new MsgRemindVO();
        if (msgRemindPO != null) {
            BeanUtils.copyProperties((Object)msgRemindPO, (Object)result);
        }
        return ResponseUtil.success((Object)result);
    }

    @Override
    public ResponseData<Boolean> saveMsgRemind(MsgTemplateRemindSaveRequestParam requestParam) {
        AssertUtil.notNull("", requestParam.getTemplateType(), requestParam.getDays());
        AssertUtil.judge(MsgSendTimeTemplateTypeMap.containsKey((Object)requestParam.getTemplateType()), "templateType\u4e0d\u5b58\u5728!");
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestParam.getTemplateType());
        if (msgRemindPO != null) {
            return this.updateMsgRemind(requestParam, msgRemindPO);
        }
        return this.addMsgRemind(requestParam);
    }

    @Override
    public ResponseData<MsgRemindDetailResponseVO> detail(MsgRemindDetailRequestVO requestVO) {
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestVO.getTemplateType());
        if (msgRemindPO == null) {
            return ResponseUtil.success((Object)new MsgRemindDetailResponseVO());
        }
        MsgRemindDetailResponseVO responseVO = ConvertUtil.convertMsgRemindPO2VO(msgRemindPO);
        return ResponseUtil.success((Object)responseVO);
    }

    @Override
    public ResponseData<MsgRemindUpdateResponseVO> addOrUpdate(MsgRemindUpdateRequestVO requestVO) {
        MsgRemindPO msgRemindPO = this.msgRemindService.selectOneByTemplateType(requestVO.getTemplateType());
        if (msgRemindPO == null) {
            String businessType = MsgSendTimeTemplateTypeMap.getKey((Object)requestVO.getTemplateType()).getBusinessTypeEnum().getCode();
            MsgRemindPO msgRemindPOAdd = new MsgRemindPO();
            msgRemindPOAdd.setBusinessType(businessType);
            msgRemindPOAdd.setTemplateType(requestVO.getTemplateType());
            msgRemindPOAdd.setMsgRemindCode(UID.getUid());
            msgRemindPOAdd.setCreateUserName(requestVO.getOptUserName());
            msgRemindPOAdd.setCreateUserCode(requestVO.getOptUserCode());
            msgRemindPOAdd.setDays(requestVO.getDays());
            boolean save = this.msgRemindService.save((Object)msgRemindPOAdd);
            MsgRemindUpdateResponseVO responseVO = new MsgRemindUpdateResponseVO();
            responseVO.setOptStatus(save);
            return ResponseUtil.success((Object)responseVO);
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(MsgRemindPO::getDays, (Object)requestVO.getDays())).set(MsgRemindPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(MsgRemindPO::getModifiedUserName, (Object)requestVO.getOptUserName())).eq(MsgRemindPO::getMsgRemindCode, (Object)msgRemindPO.getMsgRemindCode());
        boolean update = this.msgRemindService.update((Wrapper)updateWrapper);
        MsgRemindUpdateResponseVO responseVO = new MsgRemindUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData addMsgRemind(MsgTemplateRemindSaveRequestParam requestParam) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        String bussinessType = MsgSendTimeTemplateTypeMap.getKey((Object)requestParam.getTemplateType()).getBusinessTypeEnum().getCode();
        MsgRemindPO msgRemindPOAdd = new MsgRemindPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgRemindPOAdd);
        msgRemindPOAdd.setCreateUserCode(optUser.getOptUserCode());
        msgRemindPOAdd.setCreateUserName(optUser.getOptUserName());
        msgRemindPOAdd.setBusinessType(bussinessType);
        msgRemindPOAdd.setMsgRemindCode(UID.getUid());
        Boolean result = this.msgRemindService.addPO(msgRemindPOAdd);
        return ResponseUtil.success((Object)result);
    }

    private ResponseData updateMsgRemind(MsgTemplateRemindSaveRequestParam requestParam, MsgRemindPO msgRemindPO) {
        OptUserDTO optUser = this.optUserService.getOptUser();
        MsgRemindPO msgRemindPOUpdate = new MsgRemindPO();
        BeanUtils.copyProperties((Object)requestParam, (Object)msgRemindPOUpdate);
        msgRemindPOUpdate.setModifiedUserCode(optUser.getOptUserCode());
        msgRemindPOUpdate.setModifiedUserName(optUser.getOptUserName());
        msgRemindPOUpdate.setMsgRemindCode(msgRemindPO.getMsgRemindCode());
        Boolean result = this.msgRemindService.updatePO(msgRemindPOUpdate);
        return ResponseUtil.success((Object)result);
    }

    public MsgRemindWrapperServiceImpl(IMsgRemindService msgRemindService, OptUserService optUserService) {
        this.msgRemindService = msgRemindService;
        this.optUserService = optUserService;
    }
}

