/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.api.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.api.model.vo.sms.mq.MsgBodyWrapperRetryVO;
import com.bizvane.message.domain.model.entity.MsgSendtimePO;
import com.bizvane.message.domain.service.IMsgSendtimeService;
import com.bizvane.message.feign.enums.msg.MsgTemplateTypeEnum;
import com.bizvane.message.feign.vo.msg.MsgBaseBodyVO;
import com.bizvane.utils.redisutils.SpringContextHolder;
import java.time.LocalDateTime;
import java.time.LocalTime;

public abstract class SubscribeMessageHelp<T extends MsgBaseBodyVO> {
    MsgSendtimePO getInSendTime(String templateType) {
        boolean preventDisturbance = MsgTemplateTypeEnum.preventDisturbance((String)templateType);
        if (!preventDisturbance) {
            return null;
        }
        IMsgSendtimeService msgSendtimeService = (IMsgSendtimeService)SpringContextHolder.getBean(IMsgSendtimeService.class);
        MsgSendtimePO msgSendtimePO = msgSendtimeService.selectOne();
        if (msgSendtimePO == null) {
            return null;
        }
        LocalTime now = LocalTime.now();
        LocalTime sendTimeStart = msgSendtimePO.getSendTimeStart();
        LocalTime sendTimeEnd = msgSendtimePO.getSendTimeEnd();
        if (now.isBefore(sendTimeStart) || now.isAfter(sendTimeEnd)) {
            return null;
        }
        return msgSendtimePO;
    }

    public MsgBodyWrapperRetryVO<T> convertSubscribeWrapperVO(String consumerMessageInfo, Class<T> cls) {
        JSONObject msgBodyWrapperVO = JSONObject.parseObject((String)consumerMessageInfo);
        MsgBaseBodyVO messageInfo = (MsgBaseBodyVO)msgBodyWrapperVO.getObject("messageInfo", cls);
        String memberCode = msgBodyWrapperVO.getString("memberCode");
        String linkUrl = msgBodyWrapperVO.getString("linkUrl");
        MsgBodyWrapperRetryVO resultVo = new MsgBodyWrapperRetryVO();
        resultVo.setMessageInfo(messageInfo);
        resultVo.setMemberCode(memberCode);
        resultVo.setLinkUrl(linkUrl);
        resultVo.setRetryCount(msgBodyWrapperVO.getInteger("retryCount"));
        resultVo.setRetryTime((LocalDateTime)msgBodyWrapperVO.getObject("retryTime", LocalDateTime.class));
        return resultVo;
    }

    public void handlerConsumerMessageInfo(MsgTemplateTypeEnum templateTypeEnum, String consumerMessageInfo) {
        MsgSendtimePO inSendTime = this.getInSendTime(templateTypeEnum.getCode());
        if (inSendTime != null) {
            this.resend(consumerMessageInfo, inSendTime);
        } else {
            this.handler(consumerMessageInfo);
        }
    }

    public abstract void resend(String var1, MsgSendtimePO var2);

    public abstract void handler(String var1);

    public static void main(String[] args) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("now", (Object)LocalDateTime.now());
        System.out.println(jsonObject.toJSONString());
    }
}

