package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrIntegralRegistrationAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralRegistrationListRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralRegistrationReviewRequestParam;
import com.bizvane.members.feign.model.vo.MbrIntegralRegistrationVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/integralRegistration")
@Api("积分登记")
public interface IntegralRegistrationFeign {

    @ApiOperation(value = "新增")
    @RequestMapping(value="/add", method = RequestMethod.POST)
    ResponseData<String> add(@RequestBody MbrIntegralRegistrationAddRequestParam param);

    @ApiOperation(value = "查询列表")
    @RequestMapping(value="/list", method = RequestMethod.POST)
    ResponseData<PageInfo<MbrIntegralRegistrationVO>> list(@RequestBody MbrIntegralRegistrationListRequestParam param);

    @ApiOperation(value = "审核")
    @RequestMapping(value="/review", method = RequestMethod.POST)
    ResponseData<String> review(@RequestBody @Valid MbrIntegralRegistrationReviewRequestParam param);
}
