package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员标签定义
 * </p>
 *
 * @author Trump
 * @since 2024-09-13
 */
@Data
public class MbrLabelDefVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("标签编号")
    private String mbrLabelDefCode;

    @ApiModelProperty("标签名称")
    private String labelName;

    @ApiModelProperty("标签分组")
    private String mbrLabelTypeDefCode;

    @ApiModelProperty("使用次数")
    private Integer count;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;
}
