package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CouponEntityListResponseParam {

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("券表code")
    private String couponEntityCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券所属机构编号")
    private String airportNoOrg;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("描述")
    private String info;

    @ApiModelProperty("券装饰图片url")
    private String img;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("有效天数")
    private Integer validDay;

    @ApiModelProperty("最低消费金额(满减金额)")
    private BigDecimal minConsume;

    @ApiModelProperty("最高优惠金额")
    private BigDecimal maxPreferential;

    @ApiModelProperty("整单最低折扣限制")
    private BigDecimal minDiscount;

    @ApiModelProperty("是否允许转赠（1允许转赠，0不允许转赠）")
    private Boolean isTransfer;

    @ApiModelProperty("活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用")
    private Integer activitySuperpositionType;

    @ApiModelProperty("适用范围：1-业态，2-商户")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNo;

    @ApiModelProperty("业态编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("商户编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("发放类型：枚举类CouponSendTypeEnum，字典coupon_send_type")
    private Integer sendType;

    @ApiModelProperty("发券业务单号")
    private String sendBusinessCode;

    @ApiModelProperty("发券二级业务单号")
    private String sendBusinessCode2;

    @ApiModelProperty("发券三级业务单号")
    private String sendBusinessCode3;

    @ApiModelProperty("发券业务描述")
    private String sendBusinessName;

    @ApiModelProperty("使用类型：1-crm系统，2-外部系统")
    private Integer useType;

    @ApiModelProperty("核销人的会员code")
    private String useMemberCode;

    @ApiModelProperty("核销机场编号")
    private String useAirportNo;

    @ApiModelProperty("核销业态编号")
    private String useIndustryNo;

    @ApiModelProperty("核销商户编号")
    private String useMerchantNo;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("券使用订单金额")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty("使用时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useTime;

    @ApiModelProperty("状态：11-失败，20-未使用，25-已过期，30-已核销，35-已作废")
    private Integer couponStatus;

    @ApiModelProperty("失败原因")
    private String failDetail;

    @ApiModelProperty("转赠状态：1-转增中，2-已完成，3-已撤回")
    private Integer giveStatus;

    @ApiModelProperty("条形码url")
    private String barcodeUrl;

    @ApiModelProperty("二维码url")
    private String qrcodeUrl;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;

}
