package com.bizvane.members.feign.model.mq;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class CouponSendMQ implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期开始时间")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    private LocalDateTime validDateEnd;
}
